/*
 * Decompiled with CFR 0.152.
 */
package oak;

import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.SectionIndexer;
import oak.SectionListView;

public abstract class BaseSectionAdapter
extends BaseAdapter
implements SectionIndexer,
AbsListView.OnScrollListener {
    public static final String TAG = BaseSectionAdapter.class.getSimpleName();
    public static final int PINNED_HEADER_GONE = 0;
    public static final int PINNED_HEADER_VISIBLE = 1;
    public static final int PINNED_HEADER_PUSHED_UP = 2;

    public int getPinnedHeaderState(int position) {
        if (position < 0 || this.getCount() == 0) {
            return 0;
        }
        int section = this.getSectionForPosition(position);
        int nextSectionPosition = this.getPositionForSection(section + 1);
        if (nextSectionPosition != -1 && position == nextSectionPosition - 1) {
            return 2;
        }
        return 1;
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (view instanceof SectionListView) {
            ((SectionListView)view).configureHeaderView(firstVisibleItem);
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
    }

    public final View getView(int position, View convertView, ViewGroup parent) {
        View res = this.getAmazingView(position, convertView, parent);
        int section = this.getSectionForPosition(position);
        boolean displaySectionHeaders = this.getPositionForSection(section) == position;
        this.bindSectionHeader(res, position, displaySectionHeaders);
        return res;
    }

    protected abstract void bindSectionHeader(View var1, int var2, boolean var3);

    public abstract View getAmazingView(int var1, View var2, ViewGroup var3);

    public abstract void configurePinnedHeader(View var1, int var2, int var3);

    public abstract int getPositionForSection(int var1);

    public abstract int getSectionForPosition(int var1);

    public abstract Object[] getSections();
}

