/*
 * Decompiled with CFR 0.152.
 */
package assertk.assertions;

import assertk.Assert;
import assertk.FailureKt;
import assertk.ValueAssert;
import assertk.assertions.support.SupportKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\f\u001a;\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u0004*\b\u0012\u0004\u0012\u0002H\u00030\u00052\u0006\u0010\u0006\u001a\u0002H\u00022\u0006\u0010\u0007\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\b\u001a \u0010\t\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u001a \u0010\t\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\u000b\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r\u001a-\u0010\u000e\u001a\u00020\u0001\"\u000e\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u0004*\b\u0012\u0004\u0012\u0002H\u000f0\u00052\u0006\u0010\u0010\u001a\u0002H\u000f\u00a2\u0006\u0002\u0010\u0011\u001a3\u0010\u0012\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u0004*\b\u0012\u0004\u0012\u0002H\u00030\u00052\u0006\u0010\u0013\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0014\u001a3\u0010\u0015\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u0004*\b\u0012\u0004\u0012\u0002H\u00030\u00052\u0006\u0010\u0013\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0014\u001a3\u0010\u0016\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u0004*\b\u0012\u0004\u0012\u0002H\u00030\u00052\u0006\u0010\u0013\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0014\u001a3\u0010\u0017\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u0004*\b\u0012\u0004\u0012\u0002H\u00030\u00052\u0006\u0010\u0013\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0014\u001a;\u0010\u0018\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u0004*\b\u0012\u0004\u0012\u0002H\u00030\u00052\u0006\u0010\u0006\u001a\u0002H\u00022\u0006\u0010\u0007\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\b\u00a8\u0006\u0019"}, d2={"isBetween", "", "A", "B", "", "Lassertk/Assert;", "start", "end", "(Lassertk/Assert;Ljava/lang/Object;Ljava/lang/Object;)V", "isCloseTo", "", "value", "delta", "", "isEqualByComparingTo", "T", "expected", "(Lassertk/Assert;Ljava/lang/Comparable;)V", "isGreaterThan", "other", "(Lassertk/Assert;Ljava/lang/Object;)V", "isGreaterThanOrEqualTo", "isLessThan", "isLessThanOrEqualTo", "isStrictlyBetween", "assertk"})
@SourceDebugExtension(value={"SMAP\ncomparable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 comparable.kt\nassertk/assertions/ComparableKt\n+ 2 assert.kt\nassertk/Assert\n*L\n1#1,89:1\n50#2,8:90\n50#2,8:98\n50#2,8:106\n50#2,8:114\n50#2,8:122\n50#2,8:130\n50#2,8:138\n50#2,8:146\n50#2,8:154\n*S KotlinDebug\n*F\n+ 1 comparable.kt\nassertk/assertions/ComparableKt\n*L\n13#1:90,8\n23#1:98,8\n33#1:106,8\n43#1:114,8\n52#1:122,8\n61#1:130,8\n69#1:138,8\n77#1:146,8\n85#1:154,8\n*E\n"})
public final class ComparableKt {
    public static final <A, B extends Comparable<? super A>> void isGreaterThan(@NotNull Assert<? extends B> $this$isGreaterThan, A other) {
        Intrinsics.checkNotNullParameter($this$isGreaterThan, (String)"<this>");
        Assert<? extends B> this_$iv = $this$isGreaterThan;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Comparable actual = (Comparable)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (actual.compareTo(other) > 0) {
                    return;
                }
                SupportKt.expected$default($this$isGreaterThan, "to be greater than:" + SupportKt.show$default(other, null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final <A, B extends Comparable<? super A>> void isLessThan(@NotNull Assert<? extends B> $this$isLessThan, A other) {
        Intrinsics.checkNotNullParameter($this$isLessThan, (String)"<this>");
        Assert<? extends B> this_$iv = $this$isLessThan;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Comparable actual = (Comparable)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (actual.compareTo(other) < 0) {
                    return;
                }
                SupportKt.expected$default($this$isLessThan, "to be less than:" + SupportKt.show$default(other, null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final <A, B extends Comparable<? super A>> void isGreaterThanOrEqualTo(@NotNull Assert<? extends B> $this$isGreaterThanOrEqualTo, A other) {
        Intrinsics.checkNotNullParameter($this$isGreaterThanOrEqualTo, (String)"<this>");
        Assert<? extends B> this_$iv = $this$isGreaterThanOrEqualTo;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Comparable actual = (Comparable)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (actual.compareTo(other) >= 0) {
                    return;
                }
                SupportKt.expected$default($this$isGreaterThanOrEqualTo, "to be greater than or equal to:" + SupportKt.show$default(other, null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final <A, B extends Comparable<? super A>> void isLessThanOrEqualTo(@NotNull Assert<? extends B> $this$isLessThanOrEqualTo, A other) {
        Intrinsics.checkNotNullParameter($this$isLessThanOrEqualTo, (String)"<this>");
        Assert<? extends B> this_$iv = $this$isLessThanOrEqualTo;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Comparable actual = (Comparable)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (actual.compareTo(other) <= 0) {
                    return;
                }
                SupportKt.expected$default($this$isLessThanOrEqualTo, "to be less than or equal to:" + SupportKt.show$default(other, null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final <A, B extends Comparable<? super A>> void isBetween(@NotNull Assert<? extends B> $this$isBetween, A start, A end) {
        Intrinsics.checkNotNullParameter($this$isBetween, (String)"<this>");
        Assert<? extends B> this_$iv = $this$isBetween;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Comparable actual = (Comparable)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (actual.compareTo(start) >= 0 && actual.compareTo(end) <= 0) {
                    return;
                }
                SupportKt.expected$default($this$isBetween, "to be between:" + SupportKt.show$default(start, null, 2, null) + " and " + SupportKt.show$default(end, null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final <A, B extends Comparable<? super A>> void isStrictlyBetween(@NotNull Assert<? extends B> $this$isStrictlyBetween, A start, A end) {
        Intrinsics.checkNotNullParameter($this$isStrictlyBetween, (String)"<this>");
        Assert<? extends B> this_$iv = $this$isStrictlyBetween;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Comparable actual = (Comparable)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (actual.compareTo(start) > 0 && actual.compareTo(end) < 0) {
                    return;
                }
                SupportKt.expected$default($this$isStrictlyBetween, "to be strictly between:" + SupportKt.show$default(start, null, 2, null) + " and " + SupportKt.show$default(end, null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isCloseTo(@NotNull Assert<Float> $this$isCloseTo, float value, float delta) {
        Intrinsics.checkNotNullParameter($this$isCloseTo, (String)"<this>");
        Assert<Float> this_$iv = $this$isCloseTo;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                float actual = ((Number)((ValueAssert)this_$iv).getValue()).floatValue();
                boolean bl = false;
                if (actual >= value - delta && actual <= value + delta) {
                    return;
                }
                SupportKt.expected$default($this$isCloseTo, SupportKt.show$default(Float.valueOf(actual), null, 2, null) + " to be close to " + SupportKt.show$default(Float.valueOf(value), null, 2, null) + " with delta of " + SupportKt.show$default(Float.valueOf(delta), null, 2, null) + ", but was not", null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isCloseTo(@NotNull Assert<Double> $this$isCloseTo, double value, double delta) {
        Intrinsics.checkNotNullParameter($this$isCloseTo, (String)"<this>");
        Assert<Double> this_$iv = $this$isCloseTo;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                double actual = ((Number)((ValueAssert)this_$iv).getValue()).doubleValue();
                boolean bl = false;
                if (actual >= value - delta && actual <= value + delta) {
                    return;
                }
                SupportKt.expected$default($this$isCloseTo, SupportKt.show$default(actual, null, 2, null) + " to be close to " + SupportKt.show$default(value, null, 2, null) + " with delta of " + SupportKt.show$default(delta, null, 2, null) + ", but was not", null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final <T extends Comparable<? super T>> void isEqualByComparingTo(@NotNull Assert<? extends T> $this$isEqualByComparingTo, @NotNull T expected) {
        Intrinsics.checkNotNullParameter($this$isEqualByComparingTo, (String)"<this>");
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        Assert<? extends T> this_$iv = $this$isEqualByComparingTo;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Comparable actual = (Comparable)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (actual.compareTo(expected) == 0) {
                    return;
                }
                SupportKt.fail($this$isEqualByComparingTo, expected, actual);
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }
}

