/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.base.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.pax.market.api.sdk.java.base.dto.ParamsVariableObject;
import com.pax.market.api.sdk.java.base.exception.ParseXMLException;
import com.pax.market.api.sdk.java.base.util.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)ReplaceUtils.class.getSimpleName());

    public static boolean replaceParams(String filePath, String paramVariables) {
        List<ParamsVariableObject> paramList = ReplaceUtils.exchangeValues(paramVariables);
        if (paramList == null || paramList.isEmpty()) {
            return true;
        }
        File dic = new File(filePath);
        if (dic == null || !dic.isDirectory()) {
            logger.error("Cannot find file folder " + filePath + ">>>> replace paramVariables failed");
            return false;
        }
        if (dic.listFiles() == null) {
            logger.error("There is no file under downloadFolder");
            return false;
        }
        for (File file : dic.listFiles()) {
            String s = ReplaceUtils.readFile(file);
            if (s == null) {
                logger.warn(file.getName() + " is empty, skipped");
                continue;
            }
            if (!(s.startsWith("<?xml") ? ReplaceUtils.doXmlReplacementFailed(paramList, file) : s.startsWith("{") && ReplaceUtils.doJsonReplacementFailed(paramList, file))) continue;
            return false;
        }
        return true;
    }

    private static boolean doJsonReplacementFailed(List<ParamsVariableObject> paramList, File file) {
        try {
            String fullFile;
            String replaceResult = fullFile = FileUtils.readFileToString((File)file);
            if (ReplaceUtils.isJsonValidate(fullFile)) {
                for (ParamsVariableObject paramsVariableObject : paramList) {
                    String key = ReplaceUtils.escapeExprSpecialWord(paramsVariableObject.getKey());
                    String value = ReplaceUtils.escapeJson(paramsVariableObject.getValue());
                    if (!paramsVariableObject.getKey().matches("#\\{([A-Za-z0-9-_.]+)\\}")) continue;
                    replaceResult = replaceResult.replaceAll(String.format("(?i)%s", key), value);
                }
                Gson gson = new GsonBuilder().create();
                replaceResult = ReplaceUtils.processJsonReplacement(gson, replaceResult, paramList);
                if (!replaceResult.equals(fullFile)) {
                    logger.debug(file.getName() + " replaced");
                    FileUtils.writeStringToFile((File)file, (String)replaceResult);
                }
            }
        }
        catch (IOException e) {
            logger.error(" replaceParams failed ", (Throwable)e);
            return true;
        }
        return false;
    }

    private static boolean doXmlReplacementFailed(List<ParamsVariableObject> paramList, File file) {
        try {
            String fullFile;
            String replaceResult = fullFile = FileUtils.readFileToString((File)file);
            for (ParamsVariableObject paramsVariableObject : paramList) {
                String key = ReplaceUtils.escapeExprSpecialWord(paramsVariableObject.getKey());
                String value = ReplaceUtils.escapeXml(paramsVariableObject.getValue());
                if (paramsVariableObject.getKey().matches("#\\{([A-Za-z0-9-_.]+)\\}")) {
                    replaceResult = replaceResult.replaceAll(String.format("(?i)%s", key), value);
                    continue;
                }
                replaceResult = replaceResult.replaceAll(String.format("(?i)<%s>.*</%s>", key, key), String.format("<%s>%s</%s>", key, value, key));
            }
            if (!replaceResult.equals(fullFile)) {
                logger.debug(file.getName() + " replaced");
                FileUtils.writeStringToFile((File)file, (String)replaceResult);
            }
        }
        catch (IOException e) {
            logger.error(" replaceParams failed ", (Throwable)e);
            return true;
        }
        return false;
    }

    private static String processJsonReplacement(Gson gson, String oriJsonStr, List<ParamsVariableObject> paramList) {
        JsonObject jsonObject;
        try {
            jsonObject = new JsonParser().parse(oriJsonStr).getAsJsonObject();
        }
        catch (Exception e) {
            logger.warn("Invalid json parameter string: %s", (Object)oriJsonStr);
            return oriJsonStr;
        }
        if (jsonObject == null || jsonObject.isJsonNull()) {
            return oriJsonStr;
        }
        Iterator keyIter = jsonObject.keySet().iterator();
        ArrayList<ParamsVariableObject> toBeUpdatedParamList = new ArrayList<ParamsVariableObject>();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            JsonElement jsonElement = jsonObject.get(key);
            if (!jsonElement.isJsonPrimitive()) continue;
            for (ParamsVariableObject paramsVariableDto : paramList) {
                if (!key.equals(paramsVariableDto.getKey())) continue;
                ParamsVariableObject paramsVariableObject = new ParamsVariableObject();
                paramsVariableObject.setKey(key);
                paramsVariableObject.setValue(paramsVariableDto.getValue());
                toBeUpdatedParamList.add(paramsVariableObject);
            }
        }
        if (!toBeUpdatedParamList.isEmpty()) {
            for (ParamsVariableObject paramsVariableInfo : toBeUpdatedParamList) {
                jsonObject.remove(paramsVariableInfo.getKey());
                jsonObject.addProperty(paramsVariableInfo.getKey(), paramsVariableInfo.getValue());
            }
        }
        return jsonObject.toString();
    }

    public static boolean isHashMapJson(String json) {
        if (json == null || json.length() < 1) {
            return true;
        }
        Gson gson = new Gson();
        try {
            HashMap object = (HashMap)gson.fromJson(json, HashMap.class);
            return true;
        }
        catch (Exception e) {
            logger.error("ReplaceUtils error: >> paramVariables json:" + json + " > ", (Throwable)e);
            return false;
        }
    }

    private static List<ParamsVariableObject> exchangeValues(String json) {
        if (json != null) {
            ArrayList<ParamsVariableObject> list = new ArrayList<ParamsVariableObject>();
            Gson gson = new Gson();
            HashMap object = (HashMap)gson.fromJson(json, HashMap.class);
            if (object != null && object.size() > 0) {
                for (Map.Entry entry : object.entrySet()) {
                    ParamsVariableObject dto = new ParamsVariableObject();
                    dto.setKey((String)entry.getKey());
                    dto.setValue((String)entry.getValue());
                    list.add(dto);
                }
            }
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File fin) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fin);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String line = null;
            line = br.readLine();
            if (line != null) {
                String string = line;
                return string;
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            logger.error("read file first line failed, file is null", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("read file first line failed, IOException", (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static boolean isJsonValidate(String jsonStr) {
        try {
            JsonElement jsonElement = new JsonParser().parse(jsonStr);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static final boolean isJSONValid(Gson gson, String jsonInString) {
        try {
            gson.fromJson(jsonInString, Object.class);
            return true;
        }
        catch (JsonSyntaxException ex) {
            return false;
        }
    }

    private static String readLastLine(File fin) {
        ReversedLinesFileReader fileReader = null;
        String lastLine = null;
        try {
            fileReader = new ReversedLinesFileReader(fin);
            lastLine = fileReader.readLine();
            if (lastLine != null) {
                return lastLine;
            }
            fileReader.close();
        }
        catch (FileNotFoundException e) {
            logger.error("read file first line failed, file is null", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("read file first line failed, IOException", (Throwable)e);
        }
        return null;
    }

    public static String escapeExprSpecialWord(String keyword) {
        if (!StringUtils.isEmpty(keyword)) {
            String[] fbsArr;
            for (String key : fbsArr = new String[]{"\\", "$", "(", ")", "*", "+", ".", "[", "]", "?", "^", "{", "}", "|"}) {
                if (!keyword.contains(key)) continue;
                keyword = keyword.replace(key, "\\" + key);
            }
        }
        return keyword;
    }

    private static String escapeJson(String input) {
        if (!StringUtils.isEmpty(input)) {
            String[] fbsArr;
            for (String key : fbsArr = new String[]{"\\", "\"", "\\/"}) {
                if (!input.contains(key)) continue;
                input = input.replace(key, "\\\\\\" + key);
            }
        }
        return input;
    }

    private static String getEscape(char c) {
        switch (c) {
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
        }
        return String.valueOf(c);
    }

    public static String escapeXml(String src) {
        if (src == null || src.length() == 0) {
            return src;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < src.length(); ++i) {
            buf.append(ReplaceUtils.getEscape(src.charAt(i)));
        }
        return Matcher.quoteReplacement(buf.toString());
    }

    public HashMap<String, String> parseDownloadParamXml(String transMessage) throws ParseXMLException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (transMessage != null && !transMessage.isEmpty()) {
            try {
                SAXReader saxReader = new SAXReader();
                Document document = saxReader.read((InputStream)new ByteArrayInputStream(transMessage.getBytes("UTF-8")));
                Element root = document.getRootElement();
                Iterator it = root.elementIterator();
                while (it.hasNext()) {
                    Element element = (Element)it.next();
                    resultMap.put(element.getName(), element.getText());
                }
            }
            catch (Exception e) {
                throw new ParseXMLException(e);
            }
        } else {
            logger.info("parseDownloadParamXml: file is null, please make sure the file is correct.");
        }
        return resultMap;
    }
}

