/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.base.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;

public class Md5Utils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMD5(File file) {
        if (!file.isFile()) {
            return null;
        }
        FileInputStream in = null;
        try {
            String md5;
            in = new FileInputStream(file);
            String string = md5 = Md5Utils.getFileMD5(in);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String getFileMD5(InputStream fis) throws Exception {
        MessageDigest md = null;
        md = MessageDigest.getInstance("MD5");
        byte[] dataBytes = new byte[1024];
        int nread = 0;
        while ((nread = fis.read(dataBytes)) != -1) {
            md.update(dataBytes, 0, nread);
        }
        byte[] mdbytes = md.digest();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mdbytes.length; ++i) {
            sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
        }
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < mdbytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & mdbytes[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        String result = hexString.toString();
        return result;
    }

    public static Map<String, String> getDirMD5(File file, boolean listChild) {
        if (!file.isDirectory()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        File[] files = file.listFiles();
        for (File f : files != null ? files : new File[]{}) {
            if (f.isDirectory() && listChild) {
                map.putAll(Md5Utils.getDirMD5(f, listChild));
                continue;
            }
            String md5 = Md5Utils.getFileMD5(f);
            if (md5 == null) continue;
            map.put(f.getPath(), md5);
        }
        return map;
    }

    public static String getMd5(String str) {
        MessageDigest digest = null;
        StringBuilder sb = new StringBuilder(40);
        try {
            byte[] bs;
            digest = MessageDigest.getInstance("MD5");
            for (byte x : bs = digest.digest(str.getBytes())) {
                if ((x & 0xFF) >> 4 == 0) {
                    sb.append("0").append(Integer.toHexString(x & 0xFF));
                    continue;
                }
                sb.append(Integer.toHexString(x & 0xFF));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }
}

