/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.util;

import com.pax.market.api.sdk.java.api.util.StringUtils;
import java.io.File;
import java.security.SecureRandom;

public class FileUtils {
    public static boolean deleteFile(String sPath) {
        if (sPath == null || "".equals(sPath.trim())) {
            return false;
        }
        boolean flag = false;
        File file = new File(sPath);
        if (file.isFile() && file.exists()) {
            file.delete();
            flag = true;
        }
        return flag;
    }

    public static String generateMixString(int length) {
        String ALLCHAR = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuilder sb = new StringBuilder();
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < length; ++i) {
            sb.append(ALLCHAR.charAt(random.nextInt(ALLCHAR.length())));
        }
        return sb.toString();
    }

    public static boolean moveToFatherFolder(String pathName) {
        File[] files;
        String endPath = pathName.substring(0, pathName.lastIndexOf(File.separator));
        if (!new File(pathName).exists() || new File(pathName).listFiles().length == 0 || pathName.lastIndexOf(File.separator) == 0 || !new File(endPath).exists()) {
            System.out.println(" moveToFatherFolder >>> Dictionary is not exits, has no child files or has no parent dictionary");
            return false;
        }
        for (File startFile : files = new File(pathName).listFiles()) {
            try {
                if (startFile.renameTo(new File(endPath + startFile.getName()))) continue;
                System.out.println(startFile.getName() + " >> File is failed to move!");
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        try {
            new File(pathName).delete();
        }
        catch (Exception e) {
            System.out.println("Delete endPath failed!");
            return false;
        }
        return true;
    }

    public static void delFolder(String folderPath) {
        try {
            FileUtils.delAllFile(folderPath);
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean delAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            FileUtils.delAllFile(path + "/" + tempList[i]);
            FileUtils.delFolder(path + "/" + tempList[i]);
            flag = true;
        }
        return flag;
    }

    public static int getBase64FileSize(String base64Str) {
        if (StringUtils.isEmpty(base64Str)) {
            return 0;
        }
        String str = base64Str.substring(base64Str.lastIndexOf(",") + 1);
        int equalIndex = str.indexOf("=");
        if (str.indexOf("=") > 0) {
            str = str.substring(0, equalIndex);
        }
        int strLength = str.length();
        int size = strLength - strLength / 8 * 2;
        return size;
    }

    public static int getBase64FileSizeKB(String base64Str) {
        return FileUtils.getBase64FileSize(base64Str) / 1024;
    }
}

