/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.entityAttribute;

import com.google.gson.Gson;
import com.pax.market.api.sdk.java.api.BaseThirdPartySysApi;
import com.pax.market.api.sdk.java.api.base.dto.EmptyResponse;
import com.pax.market.api.sdk.java.api.base.dto.PageRequestDTO;
import com.pax.market.api.sdk.java.api.base.dto.Result;
import com.pax.market.api.sdk.java.api.base.request.SdkRequest;
import com.pax.market.api.sdk.java.api.client.ThirdPartySysApiClient;
import com.pax.market.api.sdk.java.api.entityAttribute.dto.EntityAttributeCreateRequest;
import com.pax.market.api.sdk.java.api.entityAttribute.dto.EntityAttributeDTO;
import com.pax.market.api.sdk.java.api.entityAttribute.dto.EntityAttributeLabelUpdateRequest;
import com.pax.market.api.sdk.java.api.entityAttribute.dto.EntityAttributePageResponse;
import com.pax.market.api.sdk.java.api.entityAttribute.dto.EntityAttributeResponse;
import com.pax.market.api.sdk.java.api.entityAttribute.dto.EntityAttributeUpdateRequest;
import com.pax.market.api.sdk.java.api.terminalVariable.TerminalVariableApi;
import com.pax.market.api.sdk.java.api.util.EnhancedJsonUtils;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityAttributeApi
extends BaseThirdPartySysApi {
    private static final Logger logger = LoggerFactory.getLogger(TerminalVariableApi.class);
    private static final String GET_ENTITY_ATTRIBUTES_URL = "/v1/3rdsys/attributes/{attributeId}";
    private static final String SEARCH_ENTITY_ATTRIBUTES_URL = "/v1/3rdsys/attributes";
    private static final String CREATE_ENTITY_ATTRIBUTES_URL = "/v1/3rdsys/attributes";
    private static final String UPDATE_ENTITY_ATTRIBUTES_URL = "/v1/3rdsys/attributes/{attributeId}";
    private static final String UPDATE_ENTITY_ATTRIBUTES_LABEL_URL = "/v1/3rdsys/attributes/{attributeId}/label";
    private static final String DELETE_ENTITY_ATTRIBUTES_URL = "/v1/3rdsys/attributes/{attributeId}";

    public EntityAttributeApi(String baseUrl, String apiKey, String apiSecret) {
        super(baseUrl, apiKey, apiSecret);
    }

    public EntityAttributeApi(String baseUrl, String apiKey, String apiSecret, Locale locale) {
        super(baseUrl, apiKey, apiSecret, locale);
    }

    public Result<EntityAttributeDTO> getEntityAttribute(Long attributeId) {
        logger.debug("attributeId=" + attributeId);
        List<String> validationErrs = EntityAttributeApi.validateId(attributeId, "parameter.attributeId.invalid");
        if (validationErrs.size() > 0) {
            return new Result<EntityAttributeDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/attributes/{attributeId}".replace("{attributeId}", attributeId + ""));
        request.setRequestMethod(SdkRequest.RequestMethod.GET);
        EntityAttributeResponse entityAttributeResponse = EnhancedJsonUtils.fromJson(client.execute(request), EntityAttributeResponse.class);
        Result<EntityAttributeDTO> result = new Result<EntityAttributeDTO>(entityAttributeResponse);
        return result;
    }

    public Result<EntityAttributeDTO> searchEntityAttributes(int pageNo, int pageSize, SearchOrderBy orderBy, String key, EntityAttributeType entityType) {
        List<String> validationErrs;
        logger.debug("key=" + key + "|entityType=" + (Object)((Object)entityType));
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        PageRequestDTO page = new PageRequestDTO();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        if (orderBy != null) {
            page.setOrderBy(orderBy.val);
        }
        if ((validationErrs = EntityAttributeApi.validate(page)).size() > 0) {
            return new Result<EntityAttributeDTO>(validationErrs);
        }
        SdkRequest request = this.getPageRequest("/v1/3rdsys/attributes", page);
        if (key != null) {
            request.addRequestParam("key", key);
        }
        if (entityType != null) {
            request.addRequestParam("entityType", entityType.val());
        }
        EntityAttributePageResponse resp = EnhancedJsonUtils.fromJson(client.execute(request), EntityAttributePageResponse.class);
        Result<EntityAttributeDTO> result = new Result<EntityAttributeDTO>(resp);
        return result;
    }

    public Result<EntityAttributeDTO> createEntityAttribute(EntityAttributeCreateRequest createRequest) {
        List<String> validationErrs = EntityAttributeApi.validateCreate(createRequest, "parameter.attributeCreateRequest.null");
        if (validationErrs.size() > 0) {
            return new Result<EntityAttributeDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/attributes");
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)createRequest, EntityAttributeCreateRequest.class));
        EntityAttributeResponse entityAttributeResponse = EnhancedJsonUtils.fromJson(client.execute(request), EntityAttributeResponse.class);
        Result<EntityAttributeDTO> result = new Result<EntityAttributeDTO>(entityAttributeResponse);
        return result;
    }

    public Result<EntityAttributeDTO> updateEntityAttribute(Long attributeId, EntityAttributeUpdateRequest updateRequest) {
        logger.debug("attributeId=" + attributeId);
        List<String> validationErrs = EntityAttributeApi.validateUpdate(attributeId, updateRequest, "parameter.attributeId.invalid", "parameter.attributeUpdateRequest.null");
        if (validationErrs.size() > 0) {
            return new Result<EntityAttributeDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/attributes/{attributeId}".replace("{attributeId}", attributeId + ""));
        request.setRequestMethod(SdkRequest.RequestMethod.PUT);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)updateRequest, EntityAttributeUpdateRequest.class));
        EntityAttributeResponse entityAttributeResponse = EnhancedJsonUtils.fromJson(client.execute(request), EntityAttributeResponse.class);
        Result<EntityAttributeDTO> result = new Result<EntityAttributeDTO>(entityAttributeResponse);
        return result;
    }

    public Result<String> updateEntityAttributeLabel(Long attributeId, EntityAttributeLabelUpdateRequest updateLabelRequest) {
        List<String> validationErr = this.validateAttributeId(attributeId);
        if (updateLabelRequest == null) {
            validationErr.add(EntityAttributeApi.getMessage("parameter.updateLabelRequest.null"));
        }
        if (!validationErr.isEmpty()) {
            return new Result<String>(validationErr);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest(UPDATE_ENTITY_ATTRIBUTES_LABEL_URL.replace("{attributeId}", attributeId.toString()));
        request.setRequestMethod(SdkRequest.RequestMethod.PUT);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)updateLabelRequest, EntityAttributeLabelUpdateRequest.class));
        EmptyResponse emptyResponse = EnhancedJsonUtils.fromJson(client.execute(request), EmptyResponse.class);
        Result<String> result = new Result<String>(emptyResponse);
        return result;
    }

    public Result<String> deleteEntityAttribute(Long attributeId) {
        List<String> validationErrs = this.validateAttributeId(attributeId);
        if (!validationErrs.isEmpty()) {
            return new Result<String>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/attributes/{attributeId}".replace("{attributeId}", attributeId.toString()));
        request.setRequestMethod(SdkRequest.RequestMethod.DELETE);
        EmptyResponse emptyResponse = EnhancedJsonUtils.fromJson(client.execute(request), EmptyResponse.class);
        Result<String> result = new Result<String>(emptyResponse);
        return result;
    }

    private List<String> validateAttributeId(Long attributeId) {
        logger.debug("attributeId=" + attributeId);
        List<String> validationErrs = EntityAttributeApi.validateId(attributeId, "parameter.attributeId.invalid");
        return validationErrs;
    }

    public static enum EntityInputType {
        Text("TEXT"),
        Selector("SELECTOR");

        private String val;

        private EntityInputType(String inputType) {
            this.val = inputType;
        }

        public String val() {
            return this.val;
        }
    }

    public static enum EntityAttributeType {
        Merchant("Merchant"),
        Reseller("Reseller");

        private String val;

        private EntityAttributeType(String entityType) {
            this.val = entityType;
        }

        public String val() {
            return this.val;
        }
    }

    public static enum SearchOrderBy {
        EntityType_desc("a.entity_type DESC"),
        EntityType_asc("a.entity_type ASC");

        private String val;

        private SearchOrderBy(String orderBy) {
            this.val = orderBy;
        }

        public String val() {
            return this.val;
        }
    }
}

