/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.client;

import com.pax.market.api.sdk.java.api.BaseThirdPartySysApi;
import com.pax.market.api.sdk.java.api.base.request.SdkRequest;
import com.pax.market.api.sdk.java.api.util.CryptoUtils;
import com.pax.market.api.sdk.java.api.util.EnhancedJsonUtils;
import com.pax.market.api.sdk.java.api.util.ThirdPartySysHttpUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThirdPartySysApiClient {
    private static final Logger logger = LoggerFactory.getLogger((String)ThirdPartySysApiClient.class.getSimpleName());
    protected String baseUrl;
    protected String apiKey;
    protected String apiSecret;
    protected String signMethod = "hmac";
    protected int connectTimeout = 5000;
    protected int readTimeout = 5000;
    private boolean isThirdPartySys = false;
    protected int retryTimes = 5;

    public ThirdPartySysApiClient(String baseUrl, String apiKey, String apiSecret) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.baseUrl = baseUrl;
        this.isThirdPartySys = true;
        if (BaseThirdPartySysApi.connectTimeout > 0) {
            this.connectTimeout = BaseThirdPartySysApi.connectTimeout;
        }
        if (BaseThirdPartySysApi.readTimeout > 0) {
            this.readTimeout = BaseThirdPartySysApi.readTimeout;
        }
        this.retryTimes = BaseThirdPartySysApi.retryTimes;
    }

    public ThirdPartySysApiClient(String baseUrl, String apiKey, String apiSecret, boolean isThirdPartySys) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.baseUrl = baseUrl;
        this.isThirdPartySys = isThirdPartySys;
        if (BaseThirdPartySysApi.connectTimeout > 0) {
            this.connectTimeout = BaseThirdPartySysApi.connectTimeout;
        }
        if (BaseThirdPartySysApi.readTimeout > 0) {
            this.readTimeout = BaseThirdPartySysApi.readTimeout;
        }
        this.retryTimes = BaseThirdPartySysApi.retryTimes;
    }

    public ThirdPartySysApiClient(String baseUrl, String apiKey, String apiSecret, int connectTimeout, int readTimeout) {
        this(baseUrl, apiKey, apiSecret);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.isThirdPartySys = true;
    }

    public ThirdPartySysApiClient(String baseUrl, String appKey, String appSecret, int connectTimeout, int readTimeout, String signMethod) {
        this(baseUrl, appKey, appSecret, connectTimeout, readTimeout);
        this.signMethod = signMethod;
    }

    public String execute(SdkRequest request) {
        request.addHeader("SDK-Language", "Java");
        request.addHeader("SDK-Version", "8.3.0");
        try {
            return this._execute(request);
        }
        catch (IOException e) {
            logger.error("IOException occurred when execute request. Details: {}", (Object)e.toString());
        }
        catch (GeneralSecurityException e) {
            logger.error("GeneralSecurityException occurred when execute request. Details: {}", (Object)e.toString());
        }
        return EnhancedJsonUtils.getSdkJson(16106);
    }

    protected String _execute(SdkRequest request) throws IOException, GeneralSecurityException {
        Long timestamp;
        if (this.apiKey != null) {
            if (this.isThirdPartySys) {
                request.addRequestParam("sysKey", this.apiKey);
            } else {
                request.addRequestParam("appKey", this.apiKey);
            }
        }
        if ((timestamp = request.getTimestamp()) == null) {
            timestamp = System.currentTimeMillis();
        }
        request.addRequestParam("timestamp", Long.toString(timestamp));
        String query = ThirdPartySysHttpUtils.buildQuery(request.getRequestParams(), "UTF-8");
        if (this.apiSecret != null) {
            String signature = CryptoUtils.signRequest(query, null, this.apiSecret, this.signMethod);
            request.addHeader("signature", signature);
        }
        String requestUrl = ThirdPartySysHttpUtils.buildRequestUrl(this.baseUrl + request.getRequestMappingUrl(), query);
        logger.info(" --> {} {}", (Object)request.getRequestMethod().getValue(), (Object)requestUrl);
        String response = !request.isCompressData() ? ThirdPartySysHttpUtils.request(requestUrl, request.getRequestMethod().getValue(), this.connectTimeout, this.readTimeout, request.getRequestBody(), request.getHeaderMap(), request.getSaveFilePath(), this.retryTimes) : ThirdPartySysHttpUtils.compressRequest(requestUrl, request.getRequestMethod().getValue(), this.connectTimeout, this.readTimeout, request.getRequestBody(), request.getHeaderMap(), request.getSaveFilePath(), this.retryTimes);
        return response;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

