/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.util;

import com.google.common.base.Predicate;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pax.market.api.sdk.java.api.util.AlgHelper;
import com.pax.market.api.sdk.java.api.util.EnhancedJsonUtils;
import com.pax.market.api.sdk.java.api.util.FileUtils;
import com.pax.market.api.sdk.java.api.util.RetryUtils;
import com.pax.market.api.sdk.java.api.util.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThirdPartySysHttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(ThirdPartySysHttpUtils.class);
    private static final int BUFFER_SIZE = 4096;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static Locale locale = Locale.CHINA;
    private static JsonParser jsonParser = new JsonParser();

    public static void setLocal(Locale locale) {
        ThirdPartySysHttpUtils.locale = locale;
    }

    private ThirdPartySysHttpUtils() {
    }

    public static String request(String requestUrl, String requestMethod, int connectTimeout, int readTimeout, String userData, Map<String, String> headerMap, int retryTimes) {
        return ThirdPartySysHttpUtils.request(requestUrl, requestMethod, connectTimeout, readTimeout, userData, headerMap, null, retryTimes);
    }

    public static String compressRequest(String requestUrl, String requestMethod, int connectTimeout, int readTimeout, String userData, Map<String, String> headerMap, int retryTimes) {
        return ThirdPartySysHttpUtils.compressRequest(requestUrl, requestMethod, connectTimeout, readTimeout, userData, headerMap, null, retryTimes);
    }

    public static String request(String requestUrl, String requestMethod, int connectTimeout, int readTimeout, String userData, Map<String, String> headerMap, String saveFilePath, int retryTimes) {
        try {
            return RetryUtils.retry(() -> ThirdPartySysHttpUtils.request(requestUrl, requestMethod, connectTimeout, readTimeout, userData, false, headerMap, saveFilePath), (Predicate<Throwable>)((Predicate)e -> ThirdPartySysHttpUtils.isExceptionShouldRetry(e)), retryTimes);
        }
        catch (Exception e2) {
            FileUtils.deleteFile(saveFilePath);
            logger.error("Exception Occurred. Details: {}", (Object)e2.toString());
            if (e2 instanceof IOException) {
                return EnhancedJsonUtils.getSdkJson(16105);
            }
            return EnhancedJsonUtils.getSdkJson(16106);
        }
    }

    public static String compressRequest(String requestUrl, String requestMethod, int connectTimeout, int readTimeout, String userData, Map<String, String> headerMap, String saveFilePath, int retryTimes) {
        try {
            return RetryUtils.retry(() -> ThirdPartySysHttpUtils.request(requestUrl, requestMethod, connectTimeout, readTimeout, userData, true, headerMap, saveFilePath), (Predicate<Throwable>)((Predicate)e -> ThirdPartySysHttpUtils.isExceptionShouldRetry(e)), retryTimes);
        }
        catch (Exception e2) {
            if (StringUtils.isNotBlank((CharSequence)saveFilePath)) {
                FileUtils.deleteFile(saveFilePath);
            }
            logger.error("Occurred. Details: {}", (Object)e2.toString());
            return EnhancedJsonUtils.getSdkJson(16105);
        }
    }

    private static boolean isExceptionShouldRetry(Throwable e) {
        if (e instanceof ConnectException) {
            return true;
        }
        return e instanceof SocketTimeoutException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String request(String requestUrl, String requestMethod, int connectTimeout, int readTimeout, String userData, boolean compressData, Map<String, String> headerMap, String saveFilePath) throws ConnectException, SocketTimeoutException {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = ThirdPartySysHttpUtils.getConnection(requestUrl, connectTimeout, readTimeout);
            String string = ThirdPartySysHttpUtils.finalRequest(urlConnection, requestMethod, userData, compressData, headerMap, saveFilePath);
            return string;
        }
        catch (IOException e) {
            if (e instanceof ConnectException) {
                throw (ConnectException)e;
            }
            if (e instanceof SocketTimeoutException) {
                throw (SocketTimeoutException)e;
            }
            logger.error("IOException Occurred. Details: {}", (Object)e.toString());
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return EnhancedJsonUtils.getSdkJson(16106);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String finalRequest(HttpURLConnection urlConnection, String requestMethod, String userData, boolean compressData, Map<String, String> headerMap, String saveFilePath) throws ConnectException, SocketTimeoutException {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        FileOutputStream fileOutputStream = null;
        String filePath = null;
        try {
            String str;
            String contentType;
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setRequestMethod(requestMethod);
            if (locale != null) {
                urlConnection.setRequestProperty("Accept-Language", ThirdPartySysHttpUtils.getLanguageTag(locale));
            }
            if (headerMap != null) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    urlConnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            if ("GET".equalsIgnoreCase(requestMethod) || "DELETE".equalsIgnoreCase(requestMethod)) {
                urlConnection.connect();
            } else {
                urlConnection.setDoOutput(true);
            }
            String rateLimit = "";
            String rateLimitRemain = "";
            String rateLimitReset = "";
            if (null != userData && userData.length() > 0) {
                try (OutputStream outputStream = null;){
                    outputStream = urlConnection.getOutputStream();
                    if (!compressData) {
                        outputStream.write(userData.getBytes(DEFAULT_CHARSET));
                    } else {
                        String hexString = AlgHelper.bytes2HexString(ThirdPartySysHttpUtils.compressData(userData.getBytes(DEFAULT_CHARSET)));
                        outputStream.write(hexString.getBytes());
                    }
                    Map<String, List<String>> map = urlConnection.getHeaderFields();
                    rateLimit = map.get("X-RateLimit-Limit") == null ? "" : map.get("X-RateLimit-Limit").get(0);
                    rateLimitRemain = map.get("X-RateLimit-Remaining") == null ? "" : map.get("X-RateLimit-Remaining").get(0);
                    rateLimitReset = map.get("X-RateLimit-Reset") == null ? "" : map.get("X-RateLimit-Reset").get(0);
                }
            }
            if (saveFilePath != null) {
                int bytesRead;
                filePath = saveFilePath + File.separator + FileUtils.generateMixString(16);
                File fileDir = new File(saveFilePath);
                if (!fileDir.exists()) {
                    fileDir.mkdirs();
                }
                fileOutputStream = new FileOutputStream(filePath);
                byte[] buffer = new byte[4096];
                while ((bytesRead = urlConnection.getInputStream().read(buffer)) != -1) {
                    fileOutputStream.write(buffer, 0, bytesRead);
                }
                String string2 = EnhancedJsonUtils.getSdkJson(0, filePath);
                return string2;
            }
            Map<String, List<String>> map = urlConnection.getHeaderFields();
            rateLimit = map.get("X-RateLimit-Limit") == null ? "" : map.get("X-RateLimit-Limit").get(0);
            rateLimitRemain = map.get("X-RateLimit-Remaining") == null ? "" : map.get("X-RateLimit-Remaining").get(0);
            rateLimitReset = map.get("X-RateLimit-Reset") == null ? "" : map.get("X-RateLimit-Reset").get(0);
            List<String> contentTypeHeaders = map.get("Content-Type");
            String string3 = contentType = contentTypeHeaders != null && contentTypeHeaders.size() > 0 ? contentTypeHeaders.get(0) : "";
            bufferedReader = urlConnection.getResponseCode() == 200 || urlConnection.getResponseCode() == 201 || urlConnection.getResponseCode() == 204 ? new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "utf-8")) : (urlConnection.getErrorStream() != null ? new BufferedReader(new InputStreamReader(urlConnection.getErrorStream(), "utf-8")) : new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "utf-8")));
            while ((str = bufferedReader.readLine()) != null) {
                stringBuilder.append(str);
            }
            String resultStr = stringBuilder.toString();
            if (!StringUtils.containsIgnoreCase((CharSequence)contentType, (CharSequence)"json") && StringUtils.isNotBlank((CharSequence)resultStr)) {
                logger.warn(resultStr);
            }
            if (StringUtils.isBlank((CharSequence)resultStr)) {
                resultStr = "{}";
            } else if (!StringUtils.startsWith((CharSequence)resultStr, (CharSequence)"{")) {
                resultStr = String.format("{%s}", resultStr);
            }
            JsonObject json = jsonParser.parse(resultStr).getAsJsonObject();
            json.addProperty("rateLimit", rateLimit);
            json.addProperty("rateLimitRemain", rateLimitRemain);
            json.addProperty("rateLimitReset", rateLimitReset);
            String string4 = json.toString();
            return string4;
        }
        catch (SocketTimeoutException localSocketTimeoutException) {
            if (StringUtils.containsIgnoreCase((CharSequence)localSocketTimeoutException.toString(), (CharSequence)"Read timed out")) {
                FileUtils.deleteFile(filePath);
                logger.error("SocketTimeoutException Occurred. Details: {}", (Object)localSocketTimeoutException.toString());
                string = EnhancedJsonUtils.getSdkJson(16104);
                return string;
            }
            throw localSocketTimeoutException;
        }
        catch (ConnectException localConnectException) {
            throw localConnectException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileUtils.deleteFile(filePath);
            logger.error("FileNotFoundException Occurred. Details: {}", (Object)fileNotFoundException.toString());
            string = EnhancedJsonUtils.getSdkJson(16111);
            return string;
        }
        catch (Exception ignored) {
            FileUtils.deleteFile(filePath);
            logger.error("Exception Occurred. Details: {}", (Object)ignored.toString());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    logger.error("IOException Occurred. Details: {}", (Object)e.toString());
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    logger.error("IOException Occurred. Details: {}", (Object)e.toString());
                }
            }
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return EnhancedJsonUtils.getSdkJson(16106);
    }

    private static HttpURLConnection getConnection(String requestUrl, int connectTimeout, int readTimeout) throws IOException {
        URL url = new URL(requestUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection connHttps = (HttpsURLConnection)conn;
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, new TrustManager[]{new TrustAllTrustManager()}, new SecureRandom());
                connHttps.setSSLSocketFactory(ctx.getSocketFactory());
                connHttps.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
            catch (GeneralSecurityException e) {
                logger.error("GeneralSecurityException Occurred. Details: {}", (Object)e.toString());
            }
            connHttps.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            conn = connHttps;
        }
        conn.setConnectTimeout(connectTimeout);
        conn.setReadTimeout(readTimeout);
        return conn;
    }

    private static URL buildGetUrl(String url, String query) throws IOException {
        if (StringUtils.isEmpty(query)) {
            return new URL(url);
        }
        return new URL(ThirdPartySysHttpUtils.buildRequestUrl(url, query));
    }

    public static String buildRequestUrl(String url, String ... queries) {
        if (queries == null || queries.length == 0) {
            return url;
        }
        StringBuilder newUrl = new StringBuilder(url);
        boolean hasQuery = url.contains("?");
        boolean hasPrepend = url.endsWith("?") || url.endsWith("&");
        for (String query : queries) {
            if (StringUtils.isEmpty(query)) continue;
            if (!hasPrepend) {
                if (hasQuery) {
                    newUrl.append("&");
                } else {
                    newUrl.append("?");
                    hasQuery = true;
                }
            }
            newUrl.append(query);
            hasPrepend = false;
        }
        return newUrl.toString();
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.areNotEmpty(name, value = entry.getValue())) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = ThirdPartySysHttpUtils.getResponseCharset(conn.getContentType());
        if (conn.getResponseCode() < 400) {
            String contentEncoding = conn.getContentEncoding();
            if ("gzip".equalsIgnoreCase(contentEncoding)) {
                return ThirdPartySysHttpUtils.getStreamAsString(new GZIPInputStream(conn.getInputStream()), charset);
            }
            return ThirdPartySysHttpUtils.getStreamAsString(conn.getInputStream(), charset);
        }
        throw new IOException(conn.getResponseCode() + " " + conn.getResponseMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    public static String decode(String value) {
        return ThirdPartySysHttpUtils.decode(value, DEFAULT_CHARSET);
    }

    public static String encode(String value) {
        return ThirdPartySysHttpUtils.encode(value, DEFAULT_CHARSET);
    }

    public static String decode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLDecoder.decode(value, charset);
            }
            catch (IOException e) {
                logger.error("IOException Occurred. Details: {}", (Object)e.toString());
            }
        }
        return result;
    }

    public static String encode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLEncoder.encode(value, charset);
            }
            catch (IOException e) {
                logger.error("IOException Occurred. Details: {}", (Object)e.toString());
            }
        }
        return result;
    }

    public static Map<String, String> splitUrlQuery(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] pairs = query.split("&");
        if (pairs != null && pairs.length > 0) {
            for (String pair : pairs) {
                String[] param = pair.split("=", 2);
                if (param == null || param.length != 2) continue;
                result.put(param[0], param[1]);
            }
        }
        return result;
    }

    public static byte[] compressData(byte[] bytes) throws IOException {
        if (null == bytes) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gzipOutputStream.write(bytes);
        gzipOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static String getLanguageTag(Locale locale) {
        if (locale != null) {
            String localeStr = locale.toString();
            return localeStr.replace("_", "-");
        }
        return null;
    }

    public static class TrustAllTrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

