/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtils {
    public static final Logger log = LoggerFactory.getLogger(RetryUtils.class);

    private RetryUtils() {
    }

    public static <T> T retry(Callable<T> f, Predicate<Throwable> shouldRetry, int quietTries, int maxTries) throws Exception {
        Preconditions.checkArgument((maxTries > 0 ? 1 : 0) != 0, (Object)"maxTries > 0");
        int nTry = 0;
        while (true) {
            try {
                ++nTry;
                return f.call();
            }
            catch (Throwable e) {
                if (nTry < maxTries && shouldRetry.apply((Object)e)) {
                    RetryUtils.awaitNextRetry(e, nTry, nTry <= quietTries);
                    continue;
                }
                Throwables.throwIfInstanceOf((Throwable)e, Exception.class);
                throw e;
            }
            break;
        }
    }

    public static <T> T retry(Callable<T> f, Predicate<Throwable> shouldRetry, int maxTries) throws Exception {
        return RetryUtils.retry(f, shouldRetry, 0, maxTries);
    }

    private static void awaitNextRetry(Throwable e, int nTry, boolean quiet) throws InterruptedException {
        long sleepMillis = RetryUtils.nextRetrySleepMillis(nTry);
        if (quiet) {
            log.debug("Failed on try {}, retrying in {},dms.", new Object[]{nTry, sleepMillis, e});
        } else {
            log.warn("Failed on try {}, retrying in {},dms.", new Object[]{nTry, sleepMillis, e});
        }
        Thread.sleep(sleepMillis);
    }

    private static long nextRetrySleepMillis(int nTry) {
        long baseSleepMillis = 1000L;
        long maxSleepMillis = 60000L;
        double fuzzyMultiplier = Math.min(Math.max(1.0 + 0.2 * ThreadLocalRandom.current().nextGaussian(), 0.0), 2.0);
        return (long)(Math.min(60000.0, 1000.0 * Math.pow(2.0, nTry - 1)) * fuzzyMultiplier);
    }
}

