/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.merchant.category;

import com.google.gson.Gson;
import com.pax.market.api.sdk.java.api.BaseThirdPartySysApi;
import com.pax.market.api.sdk.java.api.base.dto.EmptyResponse;
import com.pax.market.api.sdk.java.api.base.dto.Result;
import com.pax.market.api.sdk.java.api.base.request.SdkRequest;
import com.pax.market.api.sdk.java.api.client.ThirdPartySysApiClient;
import com.pax.market.api.sdk.java.api.merchant.category.dto.MerchantCategoryCreateRequest;
import com.pax.market.api.sdk.java.api.merchant.category.dto.MerchantCategoryDTO;
import com.pax.market.api.sdk.java.api.merchant.category.dto.MerchantCategoryListResponseDTO;
import com.pax.market.api.sdk.java.api.merchant.category.dto.MerchantCategoryResponseDTO;
import com.pax.market.api.sdk.java.api.merchant.category.dto.MerchantCategoryUpdateRequest;
import com.pax.market.api.sdk.java.api.util.EnhancedJsonUtils;
import com.pax.market.api.sdk.java.api.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MerchantCategoryApi
extends BaseThirdPartySysApi {
    private static final Logger logger = LoggerFactory.getLogger(MerchantCategoryApi.class);
    private static final String GET_CATEGORIES_URL = "/v1/3rdsys/merchantCategories";
    private static final String CREATE_CATEGORY_URL = "/v1/3rdsys/merchantCategories";
    private static final String UPDATE_CATEGORY_URL = "/v1/3rdsys/merchantCategories/{merchantCategoryId}";
    private static final String DELETE_CATEGORY_URL = "/v1/3rdsys/merchantCategories/{merchantCategoryId}";
    private static final String BATCH_CREATE_CATEGORY_URL = "/v1/3rdsys/merchantCategories/batch";
    private static final int MAX_LENGTH_CATEGORY_NAME = 128;
    private static final int MAX_LENGTH_CATEGORY_REMARKS = 255;

    public MerchantCategoryApi(String baseUrl, String apiKey, String apiSecret) {
        super(baseUrl, apiKey, apiSecret);
    }

    public MerchantCategoryApi(String baseUrl, String apiKey, String apiSecret, Locale locale) {
        super(baseUrl, apiKey, apiSecret, locale);
    }

    public Result<ArrayList<MerchantCategoryDTO>> getMerchantCategories(String name) {
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/merchantCategories");
        if (!StringUtils.isEmpty(name)) {
            request.addRequestParam("name", name);
        }
        MerchantCategoryListResponseDTO categoryList = EnhancedJsonUtils.fromJson(client.execute(request), MerchantCategoryListResponseDTO.class);
        Result<ArrayList<MerchantCategoryDTO>> result = new Result<ArrayList<MerchantCategoryDTO>>(categoryList);
        return result;
    }

    public Result<MerchantCategoryDTO> createMerchantCategory(MerchantCategoryCreateRequest merchantCategoryCreateRequest) {
        List<String> validationErrs = MerchantCategoryApi.validateCreate(merchantCategoryCreateRequest, "parameter.merchantCategoryCreateRequest.null");
        if (validationErrs.size() > 0) {
            return new Result<MerchantCategoryDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/merchantCategories");
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)merchantCategoryCreateRequest, MerchantCategoryCreateRequest.class));
        MerchantCategoryResponseDTO merchantCategoryResponseDTO = EnhancedJsonUtils.fromJson(client.execute(request), MerchantCategoryResponseDTO.class);
        Result<MerchantCategoryDTO> result = new Result<MerchantCategoryDTO>(merchantCategoryResponseDTO);
        return result;
    }

    public Result<MerchantCategoryDTO> updateMerchantCategory(Long merchantCategoryId, MerchantCategoryUpdateRequest merchantCategoryUpdateRequest) {
        List<String> validationErrs = MerchantCategoryApi.validateUpdate(merchantCategoryId, merchantCategoryUpdateRequest, "parameter.merchantCategoryId.invalid", "parameter.merchantCategoryUpdateRequest.null");
        if (validationErrs.size() > 0) {
            return new Result<MerchantCategoryDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/merchantCategories/{merchantCategoryId}".replace("{merchantCategoryId}", merchantCategoryId + ""));
        request.setRequestMethod(SdkRequest.RequestMethod.PUT);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)merchantCategoryUpdateRequest, MerchantCategoryUpdateRequest.class));
        MerchantCategoryResponseDTO merchantCategoryResponseDTO = EnhancedJsonUtils.fromJson(client.execute(request), MerchantCategoryResponseDTO.class);
        Result<MerchantCategoryDTO> result = new Result<MerchantCategoryDTO>(merchantCategoryResponseDTO);
        return result;
    }

    public Result<String> deleteMerchantCategory(Long merchantCategoryId) {
        List<String> validationErrs = MerchantCategoryApi.validateId(merchantCategoryId, "parameter.merchantCategoryId.invalid");
        if (validationErrs.size() > 0) {
            return new Result<String>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/merchantCategories/{merchantCategoryId}".replace("{merchantCategoryId}", merchantCategoryId.toString()));
        request.setRequestMethod(SdkRequest.RequestMethod.DELETE);
        EmptyResponse emptyResponse = EnhancedJsonUtils.fromJson(client.execute(request), EmptyResponse.class);
        Result<String> result = new Result<String>(emptyResponse);
        return result;
    }

    public Result<ArrayList<MerchantCategoryDTO>> batchCreateMerchantCategory(List<MerchantCategoryCreateRequest> merchantCategoryBatchCreateRequest, boolean skipExist) {
        List<String> validationErrs = this.validateBatchCreate(merchantCategoryBatchCreateRequest);
        if (validationErrs.size() > 0) {
            return new Result<ArrayList<MerchantCategoryDTO>>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest(BATCH_CREATE_CATEGORY_URL);
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addRequestParam("skipExist", skipExist + "");
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson(merchantCategoryBatchCreateRequest, List.class));
        MerchantCategoryListResponseDTO categoryList = EnhancedJsonUtils.fromJson(client.execute(request), MerchantCategoryListResponseDTO.class);
        Result<ArrayList<MerchantCategoryDTO>> result = new Result<ArrayList<MerchantCategoryDTO>>(categoryList);
        return result;
    }

    private List<String> validateBatchCreate(List<MerchantCategoryCreateRequest> merchantCategoryBatchCreateRequest) {
        ArrayList<String> validationErrs = new ArrayList<String>();
        if (merchantCategoryBatchCreateRequest == null || merchantCategoryBatchCreateRequest.size() == 0) {
            validationErrs.add(BaseThirdPartySysApi.getMessage("parameter.merchantCategoryBatchCreateRequest.invalid"));
        } else {
            MerchantCategoryCreateRequest category;
            int i;
            for (i = 0; i < merchantCategoryBatchCreateRequest.size(); ++i) {
                category = merchantCategoryBatchCreateRequest.get(i);
                if (!StringUtils.isEmpty(category.getName())) continue;
                validationErrs.add(BaseThirdPartySysApi.getMessage("merchantCategory.name.null"));
                break;
            }
            for (i = 0; i < merchantCategoryBatchCreateRequest.size(); ++i) {
                category = merchantCategoryBatchCreateRequest.get(i);
                if (category.getName() == null || category.getName().length() <= 128) continue;
                validationErrs.add(BaseThirdPartySysApi.getMessage("merchanteCategory.name.too.long").replaceAll("\\[NAME\\]", category.getName()));
            }
            for (i = 0; i < merchantCategoryBatchCreateRequest.size(); ++i) {
                category = merchantCategoryBatchCreateRequest.get(i);
                if (category.getRemarks() == null || category.getRemarks().length() <= 255) continue;
                validationErrs.add(BaseThirdPartySysApi.getMessage("merchanteCategory.remarks.too.long").replaceAll("\\[REMARKS\\]", category.getRemarks()));
            }
        }
        return validationErrs;
    }
}

