/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.pax.market.api.sdk.java.api.base.dto.SdkObject;
import com.pax.market.api.sdk.java.api.util.MessageBoudleUtil;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedJsonUtils {
    private static final Logger logger = LoggerFactory.getLogger(EnhancedJsonUtils.class);
    private static Gson gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTypeAdapter()).create();

    public static String toJson(Object object) {
        return gson.toJson(object);
    }

    public static <T> T fromJson(String sdkJsonStr, Class<T> clazz) {
        logger.debug(sdkJsonStr);
        return (T)gson.fromJson(sdkJsonStr, clazz);
    }

    public static <T> T fromJson(String sdkJsonStr, Type typeOfT) {
        logger.debug(sdkJsonStr);
        return (T)gson.fromJson(sdkJsonStr, typeOfT);
    }

    public static String getSdkJson(int resultCode) {
        String message = "";
        switch (resultCode) {
            case 16100: {
                message = "16100";
                break;
            }
            case 16101: {
                message = "16101";
                break;
            }
            case 16102: {
                message = "16102";
                break;
            }
            case 16103: {
                message = "16103";
                break;
            }
            case 16104: {
                message = "16104";
                break;
            }
            case 16105: {
                message = "16105";
                break;
            }
            case 16106: {
                message = "16106";
                break;
            }
            case 16107: {
                message = "16107";
                break;
            }
            case 16108: {
                message = "16108";
                break;
            }
            case 16109: {
                message = "16109";
                break;
            }
            case 16110: {
                message = "16110";
                break;
            }
            case 16111: {
                message = "16111";
            }
        }
        message = MessageBoudleUtil.getMessage(message, Locale.getDefault());
        return EnhancedJsonUtils.getSdkJson(resultCode, message);
    }

    public static String getSdkJson(int resultCode, String message) {
        SdkObject sdkObject = new SdkObject();
        sdkObject.setBusinessCode(resultCode);
        sdkObject.setMessage(message);
        return EnhancedJsonUtils.toJson(sdkObject);
    }

    private static class DateTypeAdapter
    implements JsonDeserializer<Date> {
        private DateFormat format;

        DateTypeAdapter() {
        }

        public DateTypeAdapter(DateFormat format) {
            this.format = format;
        }

        public synchronized Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            if (!(json instanceof JsonPrimitive)) {
                throw new JsonParseException("This is not a primitive value");
            }
            String jsonStr = json.getAsString();
            if (this.format != null) {
                try {
                    return this.format.parse(jsonStr);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            return new Date(Long.parseLong(jsonStr));
        }
    }
}

