/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api;

import com.pax.market.api.sdk.java.api.base.dto.PageRequestDTO;
import com.pax.market.api.sdk.java.api.base.request.SdkRequest;
import com.pax.market.api.sdk.java.api.exception.InvalidParamException;
import com.pax.market.api.sdk.java.api.util.MessageBoudleUtil;
import com.pax.market.api.sdk.java.api.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseThirdPartySysApi {
    private final Logger logger = LoggerFactory.getLogger(BaseThirdPartySysApi.class);
    private String baseUrl;
    private String apiKey;
    private String apiSecret;
    public static int connectTimeout;
    public static int readTimeout;
    public static int retryTimes;
    private TimeZone apiTimeZone = null;
    private static ValidatorFactory factory;

    public BaseThirdPartySysApi(String baseUrl, String apiKey, String apiSecret) {
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.setDefaultTZ(null);
        factory = Validation.buildDefaultValidatorFactory();
    }

    public BaseThirdPartySysApi(String baseUrl, String apiKey, String apiSecret, TimeZone timeZone) {
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.setDefaultTZ(timeZone);
        factory = Validation.buildDefaultValidatorFactory();
    }

    @Deprecated
    public BaseThirdPartySysApi(String baseUrl, String apiKey, String apiSecret, Locale locale) {
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.setDefaultLocal(locale);
        this.setDefaultTZ(null);
        factory = Validation.buildDefaultValidatorFactory();
    }

    @Deprecated
    public BaseThirdPartySysApi(String baseUrl, String apiKey, String apiSecret, Locale locale, TimeZone timeZone) {
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.setDefaultLocal(locale);
        this.setDefaultTZ(timeZone);
        factory = Validation.buildDefaultValidatorFactory();
    }

    private void setDefaultLocal(Locale locale) {
    }

    private void setDefaultTZ(TimeZone timeZone) {
        this.apiTimeZone = timeZone != null ? timeZone : TimeZone.getTimeZone("UTC");
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public void setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
    }

    protected SdkRequest createSdkRequest(String requestMappingUrl) {
        SdkRequest request = new SdkRequest(requestMappingUrl);
        request.addHeader("content-language", Locale.getDefault().toString());
        request.addHeader("Time-Zone", this.apiTimeZone.getID());
        return request;
    }

    protected SdkRequest getPageRequest(String requestUrl, PageRequestDTO page) {
        this.logger.debug("pageSize=" + page.getPageSize());
        this.logger.debug("pageNo" + page.getPageNo());
        this.logger.debug("orderBy" + page.getOrderBy());
        SdkRequest request = this.createSdkRequest(requestUrl);
        request.addRequestParam("limit", page.getPageSize() + "");
        request.addRequestParam("pageNo", page.getPageNo() + "");
        if (StringUtils.isNotEmpty((CharSequence)page.getOrderBy())) {
            request.addRequestParam("orderBy", page.getOrderBy());
        }
        return request;
    }

    protected static String getMessage(String key) {
        return MessageBoudleUtil.getMessage(key, Locale.getDefault());
    }

    protected static <T> List<String> validate(T t) {
        Validator validator = factory.getValidator();
        Set constraintViolations = validator.validate(t, new Class[0]);
        ArrayList<String> messageList = new ArrayList<String>();
        for (ConstraintViolation constraintViolation : constraintViolations) {
            messageList.add(constraintViolation.getPropertyPath().toString() + ":" + constraintViolation.getMessage());
        }
        return messageList;
    }

    protected static List<String> validateId(Long id, String errorMsgKey) {
        ArrayList<String> validationErrs = new ArrayList<String>();
        if (id == null || id < 0L) {
            validationErrs.add(BaseThirdPartySysApi.getMessage(errorMsgKey));
        }
        return validationErrs;
    }

    protected static List<String> validateStr(String str, String errorMsgKey) {
        ArrayList<String> validationErrs = new ArrayList<String>();
        if (str == null || str.equals("")) {
            validationErrs.add(BaseThirdPartySysApi.getMessage(errorMsgKey));
        }
        return validationErrs;
    }

    protected static <T> List<String> validateCreate(T createReq, String beanEmptyMsgKey) {
        ArrayList<String> validationErrs = new ArrayList<String>();
        if (createReq == null) {
            validationErrs.add(BaseThirdPartySysApi.getMessage(beanEmptyMsgKey));
            return validationErrs;
        }
        return BaseThirdPartySysApi.validate(createReq);
    }

    protected static List<String> validateUpdate(Long id, Object updateReq, String idInvalidMsgKey, String beanEmptyMsgKey) {
        ArrayList<String> validationErrs = new ArrayList<String>();
        if (id == null || id < 0L) {
            validationErrs.add(BaseThirdPartySysApi.getMessage(idInvalidMsgKey));
        }
        if (updateReq == null) {
            validationErrs.add(BaseThirdPartySysApi.getMessage(beanEmptyMsgKey));
        } else {
            validationErrs.addAll(BaseThirdPartySysApi.validate(updateReq));
        }
        return validationErrs;
    }

    protected static List<String> validateDelete(Object deleteReq, String beanEmptyMsgKey) {
        ArrayList<String> validationErrs = new ArrayList<String>();
        if (deleteReq == null) {
            validationErrs.add(BaseThirdPartySysApi.getMessage(beanEmptyMsgKey));
        } else {
            validationErrs.addAll(BaseThirdPartySysApi.validate(deleteReq));
        }
        return validationErrs;
    }

    public void setSDKConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new InvalidParamException("timeout can not be negative");
        }
        BaseThirdPartySysApi.connectTimeout = connectTimeout;
    }

    public void setSDKReadTimeout(int readTimeout) {
        if (readTimeout < 0) {
            throw new InvalidParamException("timeout can not be negative");
        }
        BaseThirdPartySysApi.readTimeout = readTimeout;
    }

    public void setRetryTimes(int retryTimes) {
        if (retryTimes < 1 || retryTimes > 5) {
            throw new InvalidParamException("retryTimes cannot less than 0 and grate than 5");
        }
        BaseThirdPartySysApi.retryTimes = retryTimes;
    }

    static {
        retryTimes = 5;
        factory = null;
    }

    public static enum PushStatus {
        Active("A"),
        Suspend("S");

        private String val;

        private PushStatus(String status) {
            this.val = status;
        }

        public String val() {
            return this.val;
        }
    }

    public static enum SearchOrderBy {
        CreatedDate_desc("a.created_date DESC"),
        CreatedDate_asc("a.created_date ASC");

        private String val;

        private SearchOrderBy(String orderBy) {
            this.val = orderBy;
        }

        public String val() {
            return this.val;
        }
    }
}

