/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.terminalVariable;

import com.google.gson.Gson;
import com.pax.market.api.sdk.java.api.BaseThirdPartySysApi;
import com.pax.market.api.sdk.java.api.base.dto.EmptyResponse;
import com.pax.market.api.sdk.java.api.base.dto.PageRequestDTO;
import com.pax.market.api.sdk.java.api.base.dto.Result;
import com.pax.market.api.sdk.java.api.base.request.SdkRequest;
import com.pax.market.api.sdk.java.api.client.ThirdPartySysApiClient;
import com.pax.market.api.sdk.java.api.terminalVariable.dto.ParameterVariable;
import com.pax.market.api.sdk.java.api.terminalVariable.dto.ParameterVariableDTO;
import com.pax.market.api.sdk.java.api.terminalVariable.dto.TerminalParameterVariableDeleteRequest;
import com.pax.market.api.sdk.java.api.terminalVariable.dto.TerminalParameterVariablePageResponse;
import com.pax.market.api.sdk.java.api.terminalVariable.dto.TerminalParameterVariableRequest;
import com.pax.market.api.sdk.java.api.util.CryptoUtils;
import com.pax.market.api.sdk.java.api.util.EnhancedJsonUtils;
import com.pax.market.api.sdk.java.api.util.StringUtils;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalVariableApi
extends BaseThirdPartySysApi {
    private static final Logger logger = LoggerFactory.getLogger(TerminalVariableApi.class);
    private static final String GET_TERMINAL_VARIABLE_URL = "/v1/3rdsys/terminalVariables";
    private static final String CREATE_TERMINAL_VARIABLE_URL = "/v1/3rdsys/terminalVariables";
    private static final String UPDATE_TERMINAL_VARIABLE_URL = "/v1/3rdsys/terminalVariables/{terminalVariableId}";
    private static final String DELETE_TERMINAL_VARIABLE_URL = "/v1/3rdsys/terminalVariables/{terminalVariableId}";
    private static final String BATCH_DELETION_TERMINAL_VARIABLE_URL = "/v1/3rdsys/terminalVariables/batch/deletion";

    public TerminalVariableApi(String baseUrl, String apiKey, String apiSecret) {
        super(baseUrl, apiKey, apiSecret);
    }

    public TerminalVariableApi(String baseUrl, String apiKey, String apiSecret, Locale locale) {
        super(baseUrl, apiKey, apiSecret, locale);
    }

    public Result<ParameterVariableDTO> getTerminalVariable(int pageNo, int pageSize, SearchOrderBy orderBy, String tid, String serialNo, String packageName, String key, VariableSource source) {
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        PageRequestDTO page = new PageRequestDTO();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<String> validationErrs = TerminalVariableApi.validate(page);
        if (StringUtils.isEmpty(tid) && StringUtils.isEmpty(serialNo)) {
            validationErrs.add(TerminalVariableApi.getMessage("param.tid.serialNo.empty.atSameTime"));
        }
        if (orderBy != null) {
            page.setOrderBy(orderBy.val);
        }
        SdkRequest request = this.getPageRequest("/v1/3rdsys/terminalVariables", page);
        if (tid != null) {
            request.addRequestParam("tid", tid);
        }
        if (serialNo != null) {
            request.addRequestParam("serialNo", serialNo);
        }
        if (packageName != null) {
            request.addRequestParam("packageName", packageName);
        }
        if (key != null) {
            request.addRequestParam("key", key);
        }
        if (source != null) {
            request.addRequestParam("source", source.val());
        }
        request.setRequestMethod(SdkRequest.RequestMethod.GET);
        TerminalParameterVariablePageResponse resp = EnhancedJsonUtils.fromJson(client.execute(request), TerminalParameterVariablePageResponse.class);
        Result<ParameterVariableDTO> result = new Result<ParameterVariableDTO>(resp);
        return result;
    }

    private void encryptPasswordVariable(ParameterVariable parameterVariable) {
        if (StringUtils.equals((CharSequence)"P", (CharSequence)parameterVariable.getType()) && StringUtils.isNotEmpty((CharSequence)parameterVariable.getValue())) {
            try {
                parameterVariable.setValue(CryptoUtils.byte2hex(CryptoUtils.aesEncrypt(parameterVariable.getValue().getBytes(StandardCharsets.UTF_8), CryptoUtils.encryptMD5(this.getApiSecret()))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Result<String> createTerminalVariable(TerminalParameterVariableRequest createRequest) {
        List<String> validationErrs = TerminalVariableApi.validateCreate(createRequest, "parameter.terminalVariableRequest.null");
        if (StringUtils.isEmpty(createRequest.getTid()) && StringUtils.isEmpty(createRequest.getSerialNo())) {
            validationErrs.add(TerminalVariableApi.getMessage("param.tid.serialNo.empty.atSameTime"));
        }
        if (validationErrs.size() > 0) {
            return new Result<String>(validationErrs);
        }
        for (ParameterVariable parameterVariable : createRequest.getVariableList()) {
            this.encryptPasswordVariable(parameterVariable);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/terminalVariables");
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)createRequest, TerminalParameterVariableRequest.class));
        EmptyResponse emptyResponse = EnhancedJsonUtils.fromJson(client.execute(request), EmptyResponse.class);
        Result<String> result = new Result<String>(emptyResponse);
        return result;
    }

    public Result<String> updateTerminalVariable(Long terminalVariableId, ParameterVariable updateRequest) {
        this.validateTerminalVariableId(terminalVariableId);
        this.encryptPasswordVariable(updateRequest);
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/terminalVariables/{terminalVariableId}".replace("{terminalVariableId}", terminalVariableId + ""));
        request.setRequestMethod(SdkRequest.RequestMethod.PUT);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)updateRequest, ParameterVariable.class));
        EmptyResponse emptyResponse = EnhancedJsonUtils.fromJson(client.execute(request), EmptyResponse.class);
        Result<String> result = new Result<String>(emptyResponse);
        return result;
    }

    public Result<String> deleteTerminalVariable(Long terminalVariableId) {
        this.validateTerminalVariableId(terminalVariableId);
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/terminalVariables/{terminalVariableId}".replace("{terminalVariableId}", terminalVariableId + ""));
        request.setRequestMethod(SdkRequest.RequestMethod.DELETE);
        return this.emptyResult(client, request);
    }

    public Result<String> batchDeletionTerminalVariable(TerminalParameterVariableDeleteRequest batchDeletionRequest) {
        List<String> validationErrs = TerminalVariableApi.validateDelete(batchDeletionRequest, "parameter.batchDeletionRequest.null");
        if (batchDeletionRequest != null && (batchDeletionRequest.getVariableIds() == null || batchDeletionRequest.getVariableIds().isEmpty())) {
            validationErrs.add(TerminalVariableApi.getMessage("variableIds.is.empty"));
        }
        if (validationErrs.size() > 0) {
            return new Result<String>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest(BATCH_DELETION_TERMINAL_VARIABLE_URL);
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)batchDeletionRequest, TerminalParameterVariableDeleteRequest.class));
        return this.emptyResult(client, request);
    }

    private Result<String> validateTerminalVariableId(Long terminalVariableId) {
        logger.debug("terminalVariableId=" + terminalVariableId);
        List<String> validationErrs = TerminalVariableApi.validateId(terminalVariableId, "parameter.terminalVariableId.invalid");
        if (validationErrs.size() > 0) {
            return new Result<String>(validationErrs);
        }
        return new Result<String>();
    }

    private Result<String> emptyResult(ThirdPartySysApiClient client, SdkRequest request) {
        EmptyResponse emptyResponse = EnhancedJsonUtils.fromJson(client.execute(request), EmptyResponse.class);
        return new Result<String>(emptyResponse);
    }

    public static enum VariableSource {
        TERMINAL("T"),
        MARKET("M"),
        MERCHANT("C");

        private String val;

        private VariableSource(String orderBy) {
            this.val = orderBy;
        }

        public String val() {
            return this.val;
        }
    }

    public static enum SearchOrderBy {
        Variable_desc("createdDate DESC"),
        Variable_asc("createdDate ASC");

        private String val;

        private SearchOrderBy(String orderBy) {
            this.val = orderBy;
        }

        public String val() {
            return this.val;
        }
    }
}

