/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.reseller;

import com.google.gson.Gson;
import com.pax.market.api.sdk.java.api.BaseThirdPartySysApi;
import com.pax.market.api.sdk.java.api.base.dto.EmptyResponse;
import com.pax.market.api.sdk.java.api.base.dto.PageRequestDTO;
import com.pax.market.api.sdk.java.api.base.dto.Result;
import com.pax.market.api.sdk.java.api.base.request.SdkRequest;
import com.pax.market.api.sdk.java.api.client.ThirdPartySysApiClient;
import com.pax.market.api.sdk.java.api.reseller.dto.ResellerCreateRequest;
import com.pax.market.api.sdk.java.api.reseller.dto.ResellerDTO;
import com.pax.market.api.sdk.java.api.reseller.dto.ResellerPageDTO;
import com.pax.market.api.sdk.java.api.reseller.dto.ResellerPageResponse;
import com.pax.market.api.sdk.java.api.reseller.dto.ResellerResponse;
import com.pax.market.api.sdk.java.api.reseller.dto.ResellerRkiKeyPageDTO;
import com.pax.market.api.sdk.java.api.reseller.dto.ResellerRkiKeyPageResponse;
import com.pax.market.api.sdk.java.api.reseller.dto.ResellerUpdateRequest;
import com.pax.market.api.sdk.java.api.util.EnhancedJsonUtils;
import com.pax.market.api.sdk.java.api.util.MessageBoudleUtil;
import com.pax.market.api.sdk.java.api.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResellerApi
extends BaseThirdPartySysApi {
    private static final Logger logger = LoggerFactory.getLogger((String)ResellerApi.class.getSimpleName());
    private static final String SEARCH_RESELLER_URL = "/v1/3rdsys/resellers";
    private static final String GET_RESELLER_URL = "/v1/3rdsys/resellers/{resellerId}";
    private static final String CREATE_RESELLER_URL = "/v1/3rdsys/resellers";
    private static final String UPDATE_RESELLER_URL = "/v1/3rdsys/resellers/{resellerId}";
    private static final String ACTIVATE_RESELLER_URL = "/v1/3rdsys/resellers/{resellerId}/active";
    private static final String DISABLE_RESELLER_URL = "/v1/3rdsys/resellers/{resellerId}/disable";
    private static final String DELETE_RESELLER_URL = "/v1/3rdsys/resellers/{resellerId}";
    private static final String REPLACE_RESELLER_EMAIL_URL = "/v1/3rdsys/resellers/{resellerId}/replaceEmail";
    private static final String SEARCH_RESELLER_RKI_KET_TEMPLATE_LIST_URL = "/v1/3rdsys/resellers/{resellerId}/rki/template";

    public ResellerApi(String baseUrl, String apiKey, String apiSecret) {
        super(baseUrl, apiKey, apiSecret);
    }

    public ResellerApi(String baseUrl, String apiKey, String apiSecret, Locale locale) {
        super(baseUrl, apiKey, apiSecret, locale);
    }

    public Result<ResellerPageDTO> searchReseller(int pageNo, int pageSize, ResellerSearchOrderBy orderBy, String name, ResellerStatus status) {
        List<String> validationErrs;
        logger.debug("name=" + name + "|status=" + (Object)((Object)status));
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        PageRequestDTO page = new PageRequestDTO();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        if (orderBy != null) {
            page.setOrderBy(orderBy.val);
        }
        if ((validationErrs = ResellerApi.validate(page)).size() > 0) {
            return new Result<ResellerPageDTO>(validationErrs);
        }
        SdkRequest request = this.getPageRequest("/v1/3rdsys/resellers", page);
        request.addRequestParam("name", name);
        if (status != null) {
            request.addRequestParam("status", status.val);
        }
        ResellerPageResponse resellerPageDTO = EnhancedJsonUtils.fromJson(client.execute(request), ResellerPageResponse.class);
        Result<ResellerPageDTO> result = new Result<ResellerPageDTO>(resellerPageDTO);
        return result;
    }

    public Result<ResellerDTO> getReseller(Long resellerId) {
        logger.debug("resellerId=" + resellerId);
        List<String> validationErrs = ResellerApi.validateId(resellerId, "parameter.resellerId.invalid");
        if (validationErrs.size() > 0) {
            return new Result<ResellerDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/resellers/{resellerId}".replace("{resellerId}", resellerId + ""));
        request.setRequestMethod(SdkRequest.RequestMethod.GET);
        ResellerResponse resellerResponseDTO = EnhancedJsonUtils.fromJson(client.execute(request), ResellerResponse.class);
        Result<ResellerDTO> result = new Result<ResellerDTO>(resellerResponseDTO);
        return result;
    }

    public Result<ResellerDTO> createReseller(ResellerCreateRequest resellerCreateRequest) {
        List<String> validationErrs = ResellerApi.validateCreate(resellerCreateRequest, "parameter.resellerCreateRequest.null");
        if (validationErrs.size() > 0) {
            return new Result<ResellerDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/resellers");
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)resellerCreateRequest, ResellerCreateRequest.class));
        ResellerResponse resellerResponseDTO = EnhancedJsonUtils.fromJson(client.execute(request), ResellerResponse.class);
        Result<ResellerDTO> result = new Result<ResellerDTO>(resellerResponseDTO);
        return result;
    }

    public Result<ResellerDTO> updateReseller(Long resellerId, ResellerUpdateRequest resellerUpdateRequest) {
        logger.debug("resellerId=" + resellerId);
        List<String> validationErrs = ResellerApi.validateUpdate(resellerId, resellerUpdateRequest, "parameter.resellerId.invalid", "parameter.resellerUpdateRequest.null");
        if (validationErrs.size() > 0) {
            return new Result<ResellerDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/resellers/{resellerId}".replace("{resellerId}", resellerId + ""));
        request.setRequestMethod(SdkRequest.RequestMethod.PUT);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)resellerUpdateRequest, ResellerUpdateRequest.class));
        ResellerResponse resellerResponseDTO = EnhancedJsonUtils.fromJson(client.execute(request), ResellerResponse.class);
        Result<ResellerDTO> result = new Result<ResellerDTO>(resellerResponseDTO);
        return result;
    }

    public Result<String> activateReseller(Long resellerId) {
        logger.debug("resellerId=" + resellerId);
        List<String> validationErrs = ResellerApi.validateId(resellerId, "parameter.resellerId.invalid");
        if (validationErrs.size() > 0) {
            return new Result<String>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest(ACTIVATE_RESELLER_URL.replace("{resellerId}", resellerId.toString()));
        request.setRequestMethod(SdkRequest.RequestMethod.PUT);
        EmptyResponse emptyResponse = EnhancedJsonUtils.fromJson(client.execute(request), EmptyResponse.class);
        Result<String> result = new Result<String>(emptyResponse);
        return result;
    }

    public Result<String> disableReseller(Long resellerId) {
        logger.debug("resellerId=" + resellerId);
        List<String> validationErrs = ResellerApi.validateId(resellerId, "parameter.resellerId.invalid");
        if (validationErrs.size() > 0) {
            return new Result<String>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest(DISABLE_RESELLER_URL.replace("{resellerId}", resellerId.toString()));
        request.setRequestMethod(SdkRequest.RequestMethod.PUT);
        EmptyResponse emptyResponse = EnhancedJsonUtils.fromJson(client.execute(request), EmptyResponse.class);
        Result<String> result = new Result<String>(emptyResponse);
        return result;
    }

    public Result<String> deleteReseller(Long resellerId) {
        logger.debug("resellerId=" + resellerId);
        List<String> validationErrs = ResellerApi.validateId(resellerId, "parameter.resellerId.invalid");
        if (validationErrs.size() > 0) {
            return new Result<String>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/resellers/{resellerId}".replace("{resellerId}", resellerId.toString()));
        request.setRequestMethod(SdkRequest.RequestMethod.DELETE);
        EmptyResponse emptyResponse = EnhancedJsonUtils.fromJson(client.execute(request), EmptyResponse.class);
        Result<String> result = new Result<String>(emptyResponse);
        return result;
    }

    public Result<String> replaceResellerEmail(Long resellerId, String email) {
        logger.debug("resellerId=" + resellerId);
        List<String> validationErrs = ResellerApi.validateId(resellerId, "parameter.resellerId.invalid");
        if (!StringUtils.isValidEmailAddress(email)) {
            validationErrs.add(MessageBoudleUtil.getMessage("parameter.email.invalid", Locale.getDefault()));
        }
        if (email != null && email.length() > 255) {
            validationErrs.add(MessageBoudleUtil.getMessage("parameter.email.toolong", Locale.getDefault()));
        }
        if (validationErrs.size() > 0) {
            return new Result<String>(validationErrs);
        }
        HashMap<String, String> requestBodyMap = new HashMap<String, String>();
        requestBodyMap.put("email", email);
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest(REPLACE_RESELLER_EMAIL_URL.replace("{resellerId}", resellerId.toString()));
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson(requestBodyMap, Map.class));
        EmptyResponse emptyResponse = EnhancedJsonUtils.fromJson(client.execute(request), EmptyResponse.class);
        Result<String> result = new Result<String>(emptyResponse);
        return result;
    }

    public Result<ResellerRkiKeyPageDTO> searchResellerRkiKeyList(Long resellerId, int pageNo, int pageSize, String rkiKey) {
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        PageRequestDTO page = new PageRequestDTO();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<String> validationErrs = ResellerApi.validate(page);
        if (validationErrs.size() > 0) {
            return new Result<ResellerRkiKeyPageDTO>(validationErrs);
        }
        SdkRequest request = this.getPageRequest(SEARCH_RESELLER_RKI_KET_TEMPLATE_LIST_URL.replace("{resellerId}", resellerId.toString()), page);
        request.addRequestParam("key", rkiKey);
        ResellerRkiKeyPageResponse pageResponse = EnhancedJsonUtils.fromJson(client.execute(request), ResellerRkiKeyPageResponse.class);
        Result<ResellerRkiKeyPageDTO> result = new Result<ResellerRkiKeyPageDTO>(pageResponse);
        return result;
    }

    public static enum ResellerSearchOrderBy {
        Name("name"),
        Contact("contact"),
        Phone("phone");

        private String val;

        private ResellerSearchOrderBy(String orderBy) {
            this.val = orderBy;
        }

        public String val() {
            return this.val;
        }
    }

    public static enum ResellerStatus {
        Active("A"),
        Inactive("P"),
        Suspend("S");

        private String val;

        private ResellerStatus(String status) {
            this.val = status;
        }

        public String val() {
            return this.val;
        }
    }
}

