/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.pushHistory;

import com.google.gson.reflect.TypeToken;
import com.pax.market.api.sdk.java.api.BaseThirdPartySysApi;
import com.pax.market.api.sdk.java.api.base.dto.PageRequestDTO;
import com.pax.market.api.sdk.java.api.base.dto.Result;
import com.pax.market.api.sdk.java.api.base.request.SdkRequest;
import com.pax.market.api.sdk.java.api.client.ThirdPartySysApiClient;
import com.pax.market.api.sdk.java.api.pushHistory.dto.OptimizedParameterPushHistoryDTO;
import com.pax.market.api.sdk.java.api.pushHistory.dto.ParameterPushHistoryDTO;
import com.pax.market.api.sdk.java.api.pushHistory.dto.ParameterPushHistoryPageResponse;
import com.pax.market.api.sdk.java.api.util.EnhancedJsonUtils;
import com.pax.market.api.sdk.java.api.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushHistoryApi
extends BaseThirdPartySysApi {
    private static final Logger logger = LoggerFactory.getLogger((String)PushHistoryApi.class.getSimpleName());
    private static final String SEARCH_APP_PUSH_HISTORY_URL = "/v1/3rdsys/parameter/push/history";

    public PushHistoryApi(String baseUrl, String apiKey, String apiSecret) {
        super(baseUrl, apiKey, apiSecret);
    }

    public PushHistoryApi(String baseUrl, String apiKey, String apiSecret, Locale locale) {
        super(baseUrl, apiKey, apiSecret, locale);
    }

    public Result<ParameterPushHistoryDTO> searchParameterPushHistory(int pageNo, int pageSize, String packageName, String serialNo, PushStatus pushStatus, Date pushTime) {
        Type responseType = new TypeToken<ParameterPushHistoryPageResponse<ParameterPushHistoryDTO>>(){}.getType();
        return this.searchParameterPushHistory(pageNo, pageSize, packageName, serialNo, pushStatus, pushTime, "false", "false", responseType);
    }

    public Result<OptimizedParameterPushHistoryDTO> searchOptimizedParameterPushHistory(int pageNo, int pageSize, String packageName, String serialNo, PushStatus pushStatus, Date pushTime) {
        Type responseType = new TypeToken<ParameterPushHistoryPageResponse<OptimizedParameterPushHistoryDTO>>(){}.getType();
        return this.searchParameterPushHistory(pageNo, pageSize, packageName, serialNo, pushStatus, pushTime, "false", "true", responseType);
    }

    public Result<ParameterPushHistoryDTO> searchLatestParameterPushHistory(int pageNo, int pageSize, String packageName, String serialNo, PushStatus pushStatus, Date pushTime) {
        Type responseType = new TypeToken<ParameterPushHistoryPageResponse<ParameterPushHistoryDTO>>(){}.getType();
        return this.searchParameterPushHistory(pageNo, pageSize, packageName, serialNo, pushStatus, pushTime, "true", "false", responseType);
    }

    public Result<OptimizedParameterPushHistoryDTO> searchLatestOptimizedParameterPushHistory(int pageNo, int pageSize, String packageName, String serialNo, PushStatus pushStatus, Date pushTime) {
        Type responseType = new TypeToken<ParameterPushHistoryPageResponse<OptimizedParameterPushHistoryDTO>>(){}.getType();
        return this.searchParameterPushHistory(pageNo, pageSize, packageName, serialNo, pushStatus, pushTime, "true", "true", responseType);
    }

    private <T extends Serializable> Result<T> searchParameterPushHistory(int pageNo, int pageSize, String packageName, String serialNo, PushStatus pushStatus, Date pushTime, String onlyLastPushHistory, String optimizeParameters, Type responseType) {
        List<String> validationErrsP = PushHistoryApi.validateStr(packageName, "parameter.packageName.null");
        if (validationErrsP.size() > 0) {
            return new Result(validationErrsP);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        PageRequestDTO page = new PageRequestDTO();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<String> validationErrs = PushHistoryApi.validate(page);
        if (validationErrs.size() > 0) {
            return new Result(validationErrs);
        }
        SdkRequest request = this.getPageRequest(SEARCH_APP_PUSH_HISTORY_URL, page);
        if (pushStatus != null) {
            request.addRequestParam("pushStatus", String.valueOf(pushStatus.val));
        }
        if (pushTime != null) {
            request.addRequestParam("pushTime", StringUtils.formatDateTime(pushTime, "yyyy-MM-dd HH:mm:ss Z"));
        }
        request.addRequestParam("packageName", packageName);
        request.addRequestParam("serialNo", serialNo);
        request.addRequestParam("onlyLastPushHistory", onlyLastPushHistory);
        request.addRequestParam("optimizeParameters", optimizeParameters);
        ParameterPushHistoryPageResponse parameterPushHistoryPageResponse = (ParameterPushHistoryPageResponse)EnhancedJsonUtils.fromJson(client.execute(request), responseType);
        return new Result(parameterPushHistoryPageResponse);
    }

    public static enum PushStatus {
        Success(2),
        Failed(3);

        private Integer val;

        private PushStatus(Integer status) {
            this.val = status;
        }

        public Integer val() {
            return this.val;
        }
    }
}

