/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.zookeeper;

import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.interfaces.CallbackVoid;
import com.weicoder.common.log.Logs;
import com.weicoder.zookeeper.params.ZookeeperParams;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public final class ZookeeperClient {
    private static final CuratorFramework curatorFramework = CuratorFrameworkFactory.builder().connectString(ZookeeperParams.CONNECT).connectionTimeoutMs(30000).sessionTimeoutMs(30000).canBeReadOnly(false).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3)).defaultData(null).build();

    public static CuratorFramework getCuratorFramework() {
        return curatorFramework;
    }

    public static void set(String path, byte[] bytes) {
        try {
            if (curatorFramework.checkExists().forPath(path) == null) {
                ZookeeperClient.create(path, bytes);
            } else {
                curatorFramework.setData().forPath(path, bytes);
            }
        }
        catch (Exception e) {
            Logs.error((Throwable)e);
        }
    }

    public static void setWithPersistent(String path, byte[] bytes) {
        try {
            if (curatorFramework.checkExists().forPath(path) == null) {
                ZookeeperClient.createWithPersistent(path, bytes);
            } else {
                curatorFramework.setData().forPath(path, bytes);
            }
        }
        catch (Exception e) {
            Logs.error((Throwable)e);
        }
    }

    public static void delete(String path) {
        try {
            if (curatorFramework.checkExists().forPath(path) != null) {
                curatorFramework.delete().forPath(path);
            }
        }
        catch (Exception e) {
            Logs.error((Throwable)e);
        }
    }

    public static void createWithPersistent(String path, byte[] bytes) {
        try {
            ((ACLBackgroundPathAndBytesable)curatorFramework.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(path, bytes);
        }
        catch (Exception e) {
            Logs.error((Throwable)e);
        }
    }

    public static void create(String path, byte[] bytes) {
        try {
            ((ACLBackgroundPathAndBytesable)curatorFramework.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(path, bytes);
        }
        catch (Exception e) {
            Logs.error((Throwable)e);
        }
    }

    public static byte[] get(String path) {
        try {
            return (byte[])curatorFramework.getData().forPath(path);
        }
        catch (Exception e) {
            return ArrayConstants.BYTES_EMPTY;
        }
    }

    public static void getDataAsync(final String path, CallbackVoid<byte[]> callback) {
        final BackgroundCallback background = (client, event) -> callback.callback((Object)event.getData());
        Watcher watcher = new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                    try {
                        ((ErrorListenerPathable)((BackgroundPathable)curatorFramework.getData().usingWatcher((Watcher)this)).inBackground(background)).forPath(path);
                    }
                    catch (Exception e) {
                        Logs.error((Throwable)e);
                    }
                }
            }
        };
        try {
            ((ErrorListenerPathable)((BackgroundPathable)curatorFramework.getData().usingWatcher(watcher)).inBackground(background)).forPath(path);
        }
        catch (Exception e) {
            Logs.error((Throwable)e);
        }
    }

    static {
        curatorFramework.start();
    }
}

