/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.util;

import com.weicoder.common.U;
import com.weicoder.common.W;
import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.lang.Bytes;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.lang.Sets;
import com.weicoder.common.log.Logs;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.RegexUtil;
import com.weicoder.common.util.StringUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;

public class IpUtil {
    public static final String LOCAL_IP = "127.0.0.1";
    public static final String SERVER_IP = IpUtil.getIp();
    public static final String CODE = W.C.toString(IpUtil.encode(SERVER_IP));
    private static final Set<String> IPS_ALL = Sets.newSet();
    private static final Set<String> IPS_ONE = Sets.newSet();
    private static final Set<String> IPS_TWO = Sets.newSet();
    private static final Set<String> IPS_THREE = Sets.newSet();

    public static boolean contains(String ip) {
        if (LOCAL_IP.equals(ip)) {
            return true;
        }
        String p = ".";
        String[] t = StringUtil.split(ip, "\\.");
        return IPS_ALL.contains(ip) || IPS_THREE.contains(StringUtil.add(t[0], p, t[1], p, t[2], p)) || IPS_TWO.contains(StringUtil.add(t[0], p, t[1], p)) || IPS_ONE.contains(StringUtil.add(t[0], p));
    }

    public static boolean contains(String regex, String ip) {
        return RegexUtil.is(regex, ip);
    }

    public static int equals(String ip1, String ip2) {
        int res = 0;
        byte[] b1 = Bytes.toBytes(IpUtil.encode(ip1));
        byte[] b2 = Bytes.toBytes(IpUtil.encode(ip2));
        for (int i = 0; i < 4 && b1[i] == b2[i]; ++i) {
            ++res;
        }
        return res;
    }

    public static void setProxy(String host, String port) {
        System.getProperties().setProperty("proxySet", "true");
        System.getProperties().setProperty("http.proxyHost", host);
        System.getProperties().setProperty("http.proxyPort", port);
    }

    public static String getIp() {
        if (U.E.isEmpty(SERVER_IP) && !LOCAL_IP.equals(SERVER_IP)) {
            Object[] ips = IpUtil.getIps();
            if (U.E.isEmpty(ips)) {
                return "";
            }
            Object ip = ips[0];
            for (int i = 1; i < ips.length; ++i) {
                Object tmp = ips[i];
                if (((String)tmp).startsWith("192.168") || ((String)tmp).startsWith("10.") || ((String)tmp).startsWith("172.")) continue;
                ip = tmp;
                break;
            }
            return ip;
        }
        return SERVER_IP;
    }

    public static String[] getIps() {
        try {
            List<String> list = Lists.newList();
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                Enumeration<InetAddress> ips = netInterfaces.nextElement().getInetAddresses();
                while (ips.hasMoreElements()) {
                    String ip = ips.nextElement().getHostAddress();
                    if (!RegexUtil.isIp(ip) || LOCAL_IP.equals(ip)) continue;
                    list.add(ip);
                }
            }
            return (String[])Lists.toArray(list);
        }
        catch (Exception e) {
            return ArrayConstants.STRING_EMPTY;
        }
    }

    public static String code() {
        return W.C.toString(IpUtil.encode(SERVER_IP));
    }

    public static int encode(String ip) {
        String[] t;
        if (RegexUtil.isIp(ip) && (t = ip.split("\\.")).length == 4) {
            return W.C.toInt(t[0]) << 24 | W.C.toInt(t[1]) << 16 | W.C.toInt(t[2]) << 8 | W.C.toInt(t[3]);
        }
        return 0;
    }

    public static String decode(int ip) {
        StringBuilder sb = new StringBuilder(15);
        sb.append(ip >>> 24);
        sb.append(".");
        sb.append(ip >> 16 & 0xFF);
        sb.append(".");
        sb.append(ip >> 8 & 0xFF);
        sb.append(".");
        sb.append(ip & 0xFF);
        return sb.toString();
    }

    static {
        for (String ip : CommonParams.IPS) {
            if (StringUtil.contains(ip, "*")) {
                String s = StringUtil.subStringEnd(ip, "*");
                String[] t = StringUtil.split(s, "\\.");
                if (t.length == 3) {
                    IPS_THREE.add(s);
                } else if (t.length == 2) {
                    IPS_TWO.add(s);
                } else if (t.length == 1) {
                    IPS_ONE.add(s);
                }
            } else {
                IPS_ALL.add(ip);
            }
            Logs.debug("add ips ip={}", ip);
        }
        Logs.info("add ips all={} one={} two={} three={}", IPS_ALL, IPS_ONE, IPS_TWO, IPS_THREE);
    }
}

