/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.socket;

import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.io.ChannelUtil;
import com.weicoder.common.log.Logs;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.WritableByteChannel;

public final class UdpClient {
    public static void send(String host, int port, byte[] data) {
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(new InetSocketAddress(host, port));
            socket.send(new DatagramPacket(data, data.length));
        }
        catch (IOException e) {
            Logs.error(e);
        }
    }

    public static byte[] send(String host, int port, byte[] data, int len) {
        DatagramSocket socket = new DatagramSocket();
        try {
            socket.connect(new InetSocketAddress(host, port));
            socket.send(new DatagramPacket(data, data.length));
            DatagramPacket p = new DatagramPacket(new byte[4], 4);
            socket.receive(p);
            byte[] byArray = p.getData();
            socket.close();
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Logs.error(e);
                return ArrayConstants.BYTES_EMPTY;
            }
        }
    }

    public static void write(String host, int port, byte[] data) {
        try (DatagramChannel socket = DatagramChannel.open();){
            socket.connect(new InetSocketAddress(host, port));
            ChannelUtil.write((WritableByteChannel)socket, data, false);
        }
        catch (IOException e) {
            Logs.error(e);
        }
    }

    public static byte[] write(String host, int port, byte[] data, int len) {
        byte[] byArray;
        block8: {
            DatagramChannel socket = DatagramChannel.open();
            try {
                socket.connect(new InetSocketAddress(host, port));
                ChannelUtil.write((WritableByteChannel)socket, data, false);
                byArray = ChannelUtil.read(socket, false);
                if (socket == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logs.error(e);
                    return ArrayConstants.BYTES_EMPTY;
                }
            }
            socket.close();
        }
        return byArray;
    }

    private UdpClient() {
    }
}

