/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.queue;

import com.weicoder.common.U;
import com.weicoder.common.concurrent.ScheduledUtil;
import com.weicoder.common.interfaces.CallbackVoid;
import com.weicoder.common.log.Log;
import com.weicoder.common.log.LogFactory;
import com.weicoder.common.util.MathUtil;
import java.util.Collection;
import java.util.Queue;

public class AsynQueue<E> {
    private static final Log LOG = LogFactory.getLog(AsynQueue.class);
    private Queue<E> queue;

    public AsynQueue(Queue<E> queue, CallbackVoid<E> callback, long time) {
        this.queue = queue;
        ScheduledUtil.delay(() -> {
            int n = 0;
            long c = System.currentTimeMillis();
            while (U.E.isNotEmpty(queue)) {
                Object e = queue.poll();
                callback.callback(e);
                LOG.debug("AsynQueue run i={} obj={}", ++n, e);
            }
            LOG.info("AsynQueue run size={} time={}", n, System.currentTimeMillis() - c);
        }, time);
    }

    public AsynQueue(Queue<E> queue, CallbackVoid<E> callback, int time) {
        this(queue, callback, MathUtil.multiply(time, 1000).longValue());
    }

    public boolean add(E e) {
        return this.queue.add(e);
    }

    public boolean addAll(Collection<? extends E> c) {
        return this.queue.addAll(c);
    }
}

