/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.params;

import com.weicoder.common.U;
import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.constants.SystemConstants;
import com.weicoder.common.lang.Sets;
import com.weicoder.common.params.Params;
import java.util.Set;

public final class CommonParams {
    public static final String LOG_CLASS = Params.getString("log.class", "com.weicoder.log4j.Log4j2");
    public static final int IO_BUFFERSIZE = Params.getInt("io.buffer", 8192);
    public static final String IO_MODE = Params.getString("io.mode", "nio");
    public static final String ENCODING = Params.getString("encoding", "UTF-8");
    public static final String DATE_FORMAT = Params.getString("date.format", "yyyy-MM-dd HH:mm:ss");
    public static final String BYTES = Params.getString("bytes", "high");
    public static final String ENCRYPT_KEY = Params.getString("encrypt.key", "www.weicoder.com");
    public static final String ENCRYPT_ALGO = Params.getString("encrypt.algo", "AES");
    public static final String ENCRYPT_DIGEST = Params.getString("encrypt.digest", "SHA-1");
    public static final String[] IPS = Params.getStringArray("ips", ArrayConstants.STRING_EMPTY);
    public static final String TOKEN_KEY = Params.getString("token.key");
    public static final int TOKEN_LENGHT = Params.getInt("token.lenght", 8);
    public static final short TOKEN_SIGN = Params.getShort("token.sign", (short)-128);
    public static final int TOKEN_EXPIRE = Params.getInt("token.expire", 691200);
    public static final int LOGS_LEN = Params.getInt("logs.len", 500);
    public static final Set<String> TOKEN_SERVERS = Sets.newSet(Params.getStringArray("token.servers", ArrayConstants.STRING_EMPTY));
    public static final int HTTP_CONNECT_TIMEOUT = Params.getInt("http.connect.timeout", 3000);
    public static final int HTTP_READ_TIMEOUT = Params.getInt("http.read.timeout", 10000);
    public static final int PAGE_SIZE = Params.getInt("page.size", 20);
    public static final char[] VERIFY_CODE = Params.getString("verify.code", "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ").toCharArray();
    public static final int VERIFY_LENGTH = Params.getInt("verify.length", 4);
    public static final boolean MAIN = Params.getBoolean("main", true);
    private static final String DEFAULT_PACKAGES = "com.weicoder";
    public static final String PACKAGES = CommonParams.getPackages("");
    public static final String[] CLASS_NAMES = Params.getStringArray("class.names", new String[]{"Action", "Service", "Dao", "Job", "Cache", "Impl", "Http"});

    public static boolean power(String name) {
        return Params.getBoolean("init.power." + name, true);
    }

    public static String getPackages(String name) {
        String pack = Params.getString(Params.getKey("", name, "packages"));
        if (U.E.isEmpty(pack) || DEFAULT_PACKAGES.equals(pack)) {
            return DEFAULT_PACKAGES;
        }
        return "com.weicoder," + pack;
    }

    public static int getScheduledPool(String name) {
        return Params.getInt(Params.getKey("scheduled", name, "pool"), SystemConstants.CPU_NUM);
    }

    public static boolean getScheduledDaemon(String name) {
        return Params.getBoolean(Params.getKey("scheduled", name, "daemon"), true);
    }

    public static int getExecutorPool(String name) {
        return Params.getInt(Params.getKey("executor", name, "pool"), SystemConstants.CPU_NUM);
    }

    public static boolean getExecutorDaemon(String name) {
        return Params.getBoolean(Params.getKey("executor", name, "daemon"), true);
    }

    private CommonParams() {
    }
}

