/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.log;

import com.weicoder.common.log.Log;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogJdk
implements Log {
    private Logger log;

    @Override
    public void setClass(Class<?> c) {
        this.log = c == null ? Logger.getLogger("") : Logger.getLogger(c.getSimpleName());
    }

    @Override
    public void trace(String msg, Object ... params) {
        if (this.isTrace()) {
            this.log.log(Level.ALL, msg, params);
        }
    }

    @Override
    public void trace(Throwable t) {
        if (this.isTrace()) {
            this.log.log(Level.ALL, "", t);
        }
    }

    @Override
    public void debug(String msg, Object ... params) {
        if (this.isDebug()) {
            this.log.log(Level.CONFIG, msg, params);
        }
    }

    @Override
    public void debug(Throwable t) {
        if (this.isDebug()) {
            this.log.log(Level.CONFIG, "", t);
        }
    }

    @Override
    public void info(String msg, Object ... params) {
        if (this.isInfo()) {
            this.log.log(Level.INFO, msg, params);
        }
    }

    @Override
    public void info(Throwable t) {
        if (this.isInfo()) {
            this.log.log(Level.INFO, "", t);
        }
    }

    @Override
    public void warn(String msg, Object ... params) {
        if (this.isWarn()) {
            this.log.log(Level.WARNING, msg, params);
        }
    }

    @Override
    public void warn(Throwable t) {
        if (this.isWarn()) {
            this.log.log(Level.WARNING, "", t);
        }
    }

    @Override
    public void error(String msg, Object ... params) {
        if (this.isError()) {
            this.log.log(Level.SEVERE, msg, params);
        }
    }

    @Override
    public void error(Throwable t) {
        this.error("", t);
    }

    @Override
    public void error(String msg, Throwable t) {
        if (this.isError()) {
            this.log.log(Level.SEVERE, msg, t);
        }
    }

    @Override
    public boolean isTrace() {
        return this.log.isLoggable(Level.ALL);
    }

    @Override
    public boolean isDebug() {
        return this.log.isLoggable(Level.CONFIG);
    }

    @Override
    public boolean isInfo() {
        return this.log.isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarn() {
        return this.log.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isError() {
        return this.log.isLoggable(Level.SEVERE);
    }

    @Override
    public void error(Throwable t, String msg, Object ... params) {
        this.error(t);
        this.error(msg, params);
    }
}

