/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.lang;

import com.weicoder.common.U;
import com.weicoder.common.W;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.util.ClassUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Maps {
    public static <K, V> V get(Map<K, V> map, K key, Class<V> c) {
        if (map == null || key == null || c == null) {
            return null;
        }
        V val = map.get(key);
        if (val == null) {
            val = ClassUtil.newInstance(c, new Class[0]);
            map.put(key, val);
        }
        return val;
    }

    public static <K, V> List<V> getList(Map<K, List<V>> map, K key) {
        if (map == null || key == null) {
            return W.L.emptyList();
        }
        List<Object> val = map.get(key);
        if (val == null) {
            val = Lists.newList();
            map.put(key, val);
        }
        return val;
    }

    public static <K, O, V> Map<O, V> getMap(Map<K, Map<O, V>> map, K key) {
        if (map == null || key == null) {
            return Maps.emptyMap();
        }
        Map<Object, V> val = map.get(key);
        if (val == null) {
            val = Maps.newMap();
            map.put(key, val);
        }
        return val;
    }

    public static boolean isMap(Object obj) {
        return U.E.isNotEmpty(obj) && obj instanceof Map;
    }

    public static <K, V> Map<K, V> newMap(K key, V value) {
        Map<K, V> map = Maps.newMap();
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> newMap(K[] keys, V[] values) {
        return Maps.newMap(Lists.newList(keys), Lists.newList(values));
    }

    public static <K, V> Map<K, V> newMap(List<K> keys, List<V> values) {
        if (U.E.isEmpty(keys) || U.E.isEmpty(values) || keys.size() != values.size()) {
            return Maps.emptyMap();
        }
        Map<K, V> map = Maps.newMap();
        for (int i = 0; i < keys.size(); ++i) {
            map.put(keys.get(i), values.get(i));
        }
        return map;
    }

    public static <K, V> Map<K, V> newMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> newMap(int size) {
        return new HashMap(size < 1 ? 1 : size);
    }

    public static <K, V> Map<K, V> newMap(Map<K, V> map) {
        return map == null ? new HashMap() : new HashMap<K, V>(map);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> newMaps(Map<K, V> ... maps) {
        Map<K, V> map = Maps.newMap();
        for (int i = 0; i < maps.length; ++i) {
            map.putAll(maps[i]);
        }
        return map;
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int size) {
        return new ConcurrentHashMap(size);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(Map<K, V> map) {
        return new ConcurrentHashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> emptyMap() {
        return Collections.emptyMap();
    }

    public static int size(Map<?, ?> map) {
        return U.E.isEmpty(map) ? 0 : map.size();
    }
}

