/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.io;

import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.log.Logs;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.CloseUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class ChannelUtil {
    public static byte[] read(ReadableByteChannel ch) {
        return ChannelUtil.read(ch, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] read(ReadableByteChannel ch, boolean isClose) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(CommonParams.IO_BUFFERSIZE * 10);
        try {
            ByteBuffer buffer = ByteBuffer.allocate(CommonParams.IO_BUFFERSIZE);
            int num = 0;
            while ((num = ch.read(buffer)) > 0) {
                out.write(buffer.hasArray() ? buffer.array() : ArrayConstants.BYTES_EMPTY, 0, num);
                buffer.clear();
            }
            if (!isClose) return out.toByteArray();
        }
        catch (IOException e) {
            try {
                Logs.error(e);
                if (!isClose) return out.toByteArray();
            }
            catch (Throwable throwable) {
                if (!isClose) throw throwable;
                CloseUtil.close(ch);
                throw throwable;
            }
            CloseUtil.close(ch);
            return out.toByteArray();
        }
        CloseUtil.close(ch);
        return out.toByteArray();
    }

    public static boolean write(WritableByteChannel wbc, byte[] b) {
        return ChannelUtil.write(wbc, b, true);
    }

    public static boolean write(WritableByteChannel wbc, byte[] b, boolean isClose) {
        return ChannelUtil.write(wbc, new ByteArrayInputStream(b), isClose);
    }

    public static boolean write(WritableByteChannel wbc, InputStream in) {
        return ChannelUtil.write(wbc, in, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean write(WritableByteChannel wbc, InputStream in, boolean isClose) {
        boolean bl;
        if (wbc == null || in == null) {
            return false;
        }
        ReadableByteChannel rbc = null;
        try {
            rbc = Channels.newChannel(in);
            ByteBuffer buffer = ByteBuffer.allocate(CommonParams.IO_BUFFERSIZE);
            int num = 0;
            while ((num = rbc.read(buffer)) > 0) {
                wbc.write(buffer.hasArray() ? ByteBuffer.wrap(buffer.array(), 0, num) : ByteBuffer.wrap(ArrayConstants.BYTES_EMPTY));
                buffer.clear();
            }
            bl = true;
            if (!isClose) return bl;
        }
        catch (IOException e) {
            try {
                Logs.error(e);
                if (!isClose) return false;
            }
            catch (Throwable throwable) {
                if (!isClose) throw throwable;
                CloseUtil.close(wbc, rbc, in);
                throw throwable;
            }
            CloseUtil.close(wbc, rbc, in);
            return false;
        }
        CloseUtil.close(wbc, rbc, in);
        return bl;
    }
}

