/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.crypto;

import com.weicoder.common.U;
import com.weicoder.common.codec.Hex;
import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.crypto.Encrypts;
import com.weicoder.common.lang.Bytes;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.StringUtil;
import java.security.MessageDigest;

public class Digest {
    public static String password(String text) {
        return U.E.isEmpty(text) ? "" : Digest.absolute(text, 20);
    }

    public static byte[] absolute(byte[] b) {
        return Digest.digest(Encrypts.encrypt(b));
    }

    public static String absolute(String text) {
        return Digest.digest(Encrypts.encrypt(text));
    }

    public static String absolute(String text, int len) {
        return StringUtil.resolve(Digest.absolute(text), len);
    }

    public static String digest(String text) {
        return Hex.encode(Digest.digest(StringUtil.toBytes(text)));
    }

    public static byte[] digest(byte[] b) {
        return Digest.getMessageDigest(b, CommonParams.ENCRYPT_DIGEST);
    }

    public static String md5(String text) {
        return Hex.encode(Digest.md5(StringUtil.toBytes(text)));
    }

    public static String md5(Object obj) {
        return Hex.encode(Digest.md5(Bytes.toBytes(obj)));
    }

    public static byte[] md5(byte[] b) {
        return Digest.getMessageDigest(b, "MD5");
    }

    public static String sha256(String text) {
        return Hex.encode(Digest.sha256(StringUtil.toBytes(text)));
    }

    public static byte[] sha256(byte[] b) {
        return Digest.getMessageDigest(b, "SHA-256");
    }

    public static String sha384(String text) {
        return Hex.encode(Digest.sha384(StringUtil.toBytes(text)));
    }

    public static byte[] sha384(byte[] b) {
        return Digest.getMessageDigest(b, "SHA-384");
    }

    public static String sha512(String text) {
        return Hex.encode(Digest.sha512(StringUtil.toBytes(text)));
    }

    public static byte[] sha512(byte[] b) {
        return Digest.getMessageDigest(b, "SHA-512");
    }

    public static String sha1(String text) {
        return Hex.encode(Digest.sha1(StringUtil.toBytes(text)));
    }

    public static byte[] sha1(byte[] b) {
        return Digest.getMessageDigest(b, "SHA-1");
    }

    public static byte[] getMessageDigest(byte[] b, String algorithm) {
        if (U.E.isEmptys(b, algorithm)) {
            return ArrayConstants.BYTES_EMPTY;
        }
        try {
            return MessageDigest.getInstance(algorithm).digest(b);
        }
        catch (Exception e) {
            return b;
        }
    }
}

