/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.bean;

import com.weicoder.common.bean.Result;
import com.weicoder.common.params.StateParams;

public final class StateCode
extends Result<Object> {
    public static final StateCode SUCCESS = new StateCode(StateParams.SUCCESS, StateParams.SUCCESS_MSG);
    public static final StateCode ERROR = new StateCode(StateParams.ERROR, StateParams.getMessage(StateParams.ERROR));
    public static final StateCode NULL = new StateCode(StateParams.NULL, StateParams.getMessage(StateParams.NULL));

    public static StateCode build(int code) {
        return StateCode.build(code, StateParams.getMessage(code));
    }

    public static StateCode build(int code, String message) {
        return new StateCode(code, message);
    }

    public static StateCode build(Object content) {
        return new StateCode(content);
    }

    public boolean success() {
        return this.equals(SUCCESS);
    }

    public Object[] to() {
        return new Object[]{this.code, this.message};
    }

    private StateCode(int code, String message) {
        this.code = code;
        this.content = message;
        this.message = message;
    }

    private StateCode(Object content) {
        this.code = StateParams.SUCCESS;
        this.content = content;
        this.message = StateParams.SUCCESS_MSG;
    }

    private StateCode() {
    }
}

