/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.javascript_client;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.artifacts.Artifact;
import com.webcohesion.enunciate.artifacts.ArtifactType;
import com.webcohesion.enunciate.artifacts.ClientLibraryArtifact;
import com.webcohesion.enunciate.artifacts.FileArtifact;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedTypeElement;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.module.ApiFeatureProviderModule;
import com.webcohesion.enunciate.module.ApiRegistryProviderModule;
import com.webcohesion.enunciate.module.BasicGeneratingModule;
import com.webcohesion.enunciate.module.DependencySpec;
import com.webcohesion.enunciate.module.EnunciateModule;
import com.webcohesion.enunciate.modules.jackson.EnunciateJacksonContext;
import com.webcohesion.enunciate.modules.jackson.JacksonModule;
import com.webcohesion.enunciate.modules.jackson.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.util.JacksonCodeErrors;
import com.webcohesion.enunciate.modules.jackson1.EnunciateJackson1Context;
import com.webcohesion.enunciate.modules.jackson1.Jackson1Module;
import com.webcohesion.enunciate.modules.jackson1.model.util.Jackson1CodeErrors;
import com.webcohesion.enunciate.modules.javascript_client.ClientClassnameForMethod;
import com.webcohesion.enunciate.modules.javascript_client.JavaScriptClientObjectWrapper;
import com.webcohesion.enunciate.modules.javascript_client.TypeNameForMethod;
import com.webcohesion.enunciate.modules.jaxrs.JaxrsModule;
import com.webcohesion.enunciate.util.freemarker.ClientPackageForMethod;
import com.webcohesion.enunciate.util.freemarker.FileDirective;
import com.webcohesion.enunciate.util.freemarker.IsFacetExcludedMethod;
import com.webcohesion.enunciate.util.freemarker.SimpleNameWithParamsMethod;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.apache.commons.configuration.HierarchicalConfiguration;

public class JavaScriptClientModule
extends BasicGeneratingModule
implements ApiFeatureProviderModule {
    JacksonModule jacksonModule;
    Jackson1Module jackson1Module;
    JaxrsModule jaxrsModule;

    public String getName() {
        return "javascript-client";
    }

    public List<DependencySpec> getDependencySpecifications() {
        return Arrays.asList(new DependencySpec(){

            public boolean accept(EnunciateModule module) {
                if (module instanceof JacksonModule) {
                    JavaScriptClientModule.this.jacksonModule = (JacksonModule)module;
                    return true;
                }
                if (module instanceof Jackson1Module) {
                    JavaScriptClientModule.this.jackson1Module = (Jackson1Module)module;
                    return true;
                }
                if (module instanceof JaxrsModule) {
                    JavaScriptClientModule.this.jaxrsModule = (JaxrsModule)module;
                    return true;
                }
                return module instanceof ApiRegistryProviderModule;
            }

            public boolean isFulfilled() {
                return true;
            }

            public String toString() {
                return "optional jackson, optional jackson1, optional jaxrs";
            }
        });
    }

    public void call(EnunciateContext context) {
        String pckg;
        if ((this.jacksonModule == null || this.jacksonModule.getJacksonContext() == null || this.jacksonModule.getJacksonContext().getTypeDefinitions().isEmpty()) && (this.jackson1Module == null || this.jackson1Module.getJacksonContext() == null || this.jackson1Module.getJacksonContext().getTypeDefinitions().isEmpty())) {
            this.info("No Jackson JSON data types: JavaScript client will not be generated.", new Object[0]);
            return;
        }
        this.detectAccessorNamingErrors();
        Map<String, String> packageToNamespaceConversions = this.getPackageToNamespaceConversions();
        ArrayList<TypeDefinition> schemaTypes = new ArrayList<TypeDefinition>();
        ExtensionDepthComparator comparator = new ExtensionDepthComparator();
        EnunciateJacksonContext jacksonContext = null;
        EnunciateJackson1Context jackson1Context = null;
        if (this.jacksonModule != null) {
            jacksonContext = this.jacksonModule.getJacksonContext();
            for (TypeDefinition typeDefinition : jacksonContext.getTypeDefinitions()) {
                int position;
                pckg = typeDefinition.getPackage().getQualifiedName().toString();
                if (!packageToNamespaceConversions.containsKey(pckg)) {
                    packageToNamespaceConversions.put(pckg, this.packageToNamespace(pckg));
                }
                if ((position = Collections.binarySearch(schemaTypes, typeDefinition, comparator)) < 0) {
                    position = -position - 1;
                }
                schemaTypes.add(position, typeDefinition);
            }
        }
        if (this.jackson1Module != null) {
            jackson1Context = this.jackson1Module.getJacksonContext();
            for (TypeDefinition typeDefinition : jackson1Context.getTypeDefinitions()) {
                pckg = typeDefinition.getPackage().getQualifiedName().toString();
                if (!packageToNamespaceConversions.containsKey(pckg)) {
                    packageToNamespaceConversions.put(pckg, this.packageToNamespace(pckg));
                }
                schemaTypes.add(typeDefinition);
            }
        }
        File srcDir = this.getSourceDir();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("globalName", this.config.getString("[@global]", "javascriptClient"));
        model.put("schemaTypes", schemaTypes);
        model.put("namespaceFor", new ClientPackageForMethod(packageToNamespaceConversions, this.context));
        ClientClassnameForMethod classnameFor = new ClientClassnameForMethod(packageToNamespaceConversions, jacksonContext, jackson1Context);
        model.put("classnameFor", (Object)classnameFor);
        model.put("typeNameFor", (Object)new TypeNameForMethod(packageToNamespaceConversions, jacksonContext, jackson1Context));
        model.put("simpleNameFor", new SimpleNameWithParamsMethod((com.webcohesion.enunciate.util.freemarker.ClientClassnameForMethod)classnameFor));
        model.put("jsFileName", this.getSourceFileName());
        model.put("file", new FileDirective(srcDir, this.enunciate.getLogger()));
        model.put("generatedCodeLicense", this.enunciate.getConfiguration().readGeneratedCodeLicenseFile());
        TreeSet<String> facetIncludes = new TreeSet<String>(this.enunciate.getConfiguration().getFacetIncludes());
        facetIncludes.addAll(this.getFacetIncludes());
        TreeSet<String> facetExcludes = new TreeSet<String>(this.enunciate.getConfiguration().getFacetExcludes());
        facetExcludes.addAll(this.getFacetExcludes());
        FacetFilter facetFilter = new FacetFilter(facetIncludes, facetExcludes);
        model.put("isFacetExcluded", new IsFacetExcludedMethod(facetFilter));
        if (!this.isUpToDateWithSources(srcDir)) {
            this.debug("Generating the JavaScript data classes...", new Object[0]);
            URL apiTemplate = this.getTemplateURL("api.fmt");
            try {
                this.processTemplate(apiTemplate, model);
            }
            catch (IOException e) {
                throw new EnunciateException((Throwable)e);
            }
            catch (TemplateException e) {
                throw new EnunciateException((Throwable)e);
            }
        } else {
            this.info("Skipping JavaScript code generation because everything appears up-to-date.", new Object[0]);
        }
        File packageDir = this.getPackageDir();
        packageDir.mkdirs();
        File bundle = new File(packageDir, this.getBundleFileName());
        boolean anyFiles = bundle.exists();
        if (!this.isUpToDateWithSources(packageDir)) {
            try {
                anyFiles = this.enunciate.zip(bundle, new File[]{srcDir});
            }
            catch (IOException e) {
                throw new EnunciateException((Throwable)e);
            }
        }
        if (anyFiles) {
            ClientLibraryArtifact artifactBundle = new ClientLibraryArtifact(this.getName(), "js.client.library", "JavaScript Client Library");
            artifactBundle.setPlatform("JavaScript");
            FileArtifact sourceScript = new FileArtifact(this.getName(), "javascript.client", bundle);
            sourceScript.setArtifactType(ArtifactType.binaries);
            sourceScript.setPublic(false);
            String description = this.readResource("library_description.fmt", model);
            artifactBundle.setDescription(description);
            artifactBundle.addArtifact(sourceScript);
            this.enunciate.addArtifact((Artifact)artifactBundle);
        }
    }

    protected void detectAccessorNamingErrors() {
        List namingConflicts;
        if (this.jacksonModule != null && (namingConflicts = JacksonCodeErrors.findConflictingAccessorNamingErrors((EnunciateJacksonContext)this.jacksonModule.getJacksonContext())) != null && !namingConflicts.isEmpty()) {
            this.error("Jackson naming conflicts have been found:", new Object[0]);
            for (String namingConflict : namingConflicts) {
                this.error(namingConflict, new Object[0]);
            }
            this.error("These naming conflicts are often between the field and it's associated property, in which case you need to use one or both of the following strategies to avoid the conflicts:", new Object[0]);
            this.error("1. Explicitly exclude one or the other.", new Object[0]);
            this.error("2. Put the annotations on the property instead of the field.", new Object[0]);
            throw new EnunciateException("Jackson naming conflicts detected.");
        }
        if (this.jackson1Module != null && (namingConflicts = Jackson1CodeErrors.findConflictingAccessorNamingErrors((EnunciateJackson1Context)this.jackson1Module.getJacksonContext())) != null && !namingConflicts.isEmpty()) {
            this.error("Jackson naming conflicts have been found:", new Object[0]);
            for (String namingConflict : namingConflicts) {
                this.error(namingConflict, new Object[0]);
            }
            this.error("These naming conflicts are often between the field and it's associated property, in which case you need to use one or both of the following strategies to avoid the conflicts:", new Object[0]);
            this.error("1. Explicitly exclude one or the other.", new Object[0]);
            this.error("2. Put the annotations on the property instead of the field.", new Object[0]);
            throw new EnunciateException("Jackson naming conflicts detected.");
        }
    }

    protected File getSourceDir() {
        return new File(new File(this.enunciate.getBuildDir(), this.getName()), "src");
    }

    protected File getPackageDir() {
        return new File(new File(this.enunciate.getBuildDir(), this.getName()), "build");
    }

    public String processTemplate(URL templateURL, Object model) throws IOException, TemplateException {
        this.debug("Processing template %s.", new Object[]{templateURL});
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_22);
        configuration.setTemplateLoader((TemplateLoader)new URLTemplateLoader(){

            protected URL getURL(String name) {
                try {
                    return new URL(name);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        });
        configuration.setTemplateExceptionHandler(new TemplateExceptionHandler(){

            public void handleTemplateException(TemplateException templateException, Environment environment, Writer writer) throws TemplateException {
                throw templateException;
            }
        });
        configuration.setLocalizedLookup(false);
        configuration.setDefaultEncoding("UTF-8");
        configuration.setObjectWrapper((ObjectWrapper)new JavaScriptClientObjectWrapper());
        Template template = configuration.getTemplate(templateURL.toString());
        StringWriter unhandledOutput = new StringWriter();
        template.process(model, (Writer)unhandledOutput);
        unhandledOutput.close();
        return unhandledOutput.toString();
    }

    protected String packageToNamespace(String pckg) {
        if (pckg == null) {
            return null;
        }
        StringBuilder ns = new StringBuilder();
        StringTokenizer toks = new StringTokenizer(pckg, ".");
        while (toks.hasMoreTokens()) {
            String tok = toks.nextToken();
            ns.append(Character.toString(tok.charAt(0)).toUpperCase());
            if (tok.length() > 1) {
                ns.append(tok.substring(1));
            }
            if (!toks.hasMoreTokens()) continue;
            ns.append(".");
        }
        return ns.toString();
    }

    protected String getBundleFileName() {
        return this.getSlug() + "-js.zip";
    }

    protected String readResource(String resource, Map<String, Object> model) {
        model.put("sample_resource", this.findExampleResourceMethod());
        URL res = JavaScriptClientModule.class.getResource(resource);
        try {
            return this.processTemplate(res, model);
        }
        catch (TemplateException e) {
            throw new EnunciateException((Throwable)e);
        }
        catch (IOException e) {
            throw new EnunciateException((Throwable)e);
        }
    }

    public Method findExampleResourceMethod() {
        Method example = null;
        List resourceGroups = this.jaxrsModule.getJaxrsContext().getResourceGroups();
        for (ResourceGroup resourceGroup : resourceGroups) {
            List resources = resourceGroup.getResources();
            for (Resource resource : resources) {
                for (Method method : resource.getMethods()) {
                    if (!this.hasXmlResponseEntity(method)) continue;
                    if (this.hasXmlRequestEntity(method)) {
                        return method;
                    }
                    example = example == null ? method : example;
                }
            }
        }
        return example;
    }

    private boolean hasXmlResponseEntity(Method method) {
        if (method.getResponseEntity() != null) {
            for (MediaTypeDescriptor mediaTypeDescriptor : method.getResponseEntity().getMediaTypes()) {
                if (!"JSON".equals(mediaTypeDescriptor.getSyntax())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasXmlRequestEntity(Method method) {
        if (method.getRequestEntity() != null) {
            for (MediaTypeDescriptor mediaTypeDescriptor : method.getRequestEntity().getMediaTypes()) {
                if (!"JSON".equals(mediaTypeDescriptor.getSyntax())) continue;
                return true;
            }
        }
        return false;
    }

    protected String getSourceFileName() {
        return this.getSlug() + ".js";
    }

    protected URL getTemplateURL(String template) {
        return JavaScriptClientModule.class.getResource(template);
    }

    public String getSlug() {
        return this.config.getString("[@slug]", this.enunciate.getConfiguration().getSlug());
    }

    public Map<String, String> getPackageToNamespaceConversions() {
        List conversionElements = this.config.configurationsAt("package-conversions.convert");
        HashMap<String, String> conversions = new HashMap<String, String>();
        for (HierarchicalConfiguration conversionElement : conversionElements) {
            conversions.put(conversionElement.getString("[@from]"), conversionElement.getString("[@to]"));
        }
        return conversions;
    }

    public Set<String> getFacetIncludes() {
        List includes = this.config.getList("facets.include[@name]");
        TreeSet<String> facetIncludes = new TreeSet<String>();
        for (Object include : includes) {
            facetIncludes.add(String.valueOf(include));
        }
        return facetIncludes;
    }

    public Set<String> getFacetExcludes() {
        List excludes = this.config.getList("facets.exclude[@name]");
        TreeSet<String> facetExcludes = new TreeSet<String>();
        for (Object exclude : excludes) {
            facetExcludes.add(String.valueOf(exclude));
        }
        return facetExcludes;
    }

    private static final class ExtensionDepthComparator
    implements Comparator<DecoratedTypeElement> {
        private ExtensionDepthComparator() {
        }

        @Override
        public int compare(DecoratedTypeElement t1, DecoratedTypeElement t2) {
            int depth1 = 0;
            int depth2 = 0;
            DecoratedTypeMirror superType = (DecoratedTypeMirror)t1.getSuperclass();
            while (superType != null && superType.isDeclared() && !Object.class.getName().equals(((TypeElement)((DeclaredType)superType).asElement()).getQualifiedName().toString())) {
                ++depth1;
                superType = (DecoratedTypeMirror)((TypeElement)((DeclaredType)superType).asElement()).getSuperclass();
            }
            superType = (DecoratedTypeMirror)t2.getSuperclass();
            while (superType != null && superType.isDeclared() && !Object.class.getName().equals(((TypeElement)((DeclaredType)superType).asElement()).getQualifiedName().toString())) {
                ++depth2;
                superType = (DecoratedTypeMirror)((TypeElement)((DeclaredType)superType).asElement()).getSuperclass();
            }
            return depth1 - depth2;
        }
    }
}

