/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.java_xml_client;

import com.sun.tools.javac.api.JavacTool;
import com.webcohesion.enunciate.Enunciate;
import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.DefaultRegistrationContext;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.artifacts.Artifact;
import com.webcohesion.enunciate.artifacts.ArtifactType;
import com.webcohesion.enunciate.artifacts.ClientLibraryJavaArtifact;
import com.webcohesion.enunciate.artifacts.FileArtifact;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.SourcePosition;
import com.webcohesion.enunciate.metadata.DocumentationExample;
import com.webcohesion.enunciate.module.ApiFeatureProviderModule;
import com.webcohesion.enunciate.module.ApiRegistryProviderModule;
import com.webcohesion.enunciate.module.BasicGeneratingModule;
import com.webcohesion.enunciate.module.DependencySpec;
import com.webcohesion.enunciate.module.EnunciateModule;
import com.webcohesion.enunciate.module.ProjectExtensionModule;
import com.webcohesion.enunciate.modules.java_xml_client.ClientClassnameForMethod;
import com.webcohesion.enunciate.modules.java_xml_client.JavaXMLClientObjectWrapper;
import com.webcohesion.enunciate.modules.java_xml_client.MediaTypeForMethod;
import com.webcohesion.enunciate.modules.java_xml_client.SimpleNameForMethod;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.JaxbModule;
import com.webcohesion.enunciate.modules.jaxb.model.QNameEnumTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.Registry;
import com.webcohesion.enunciate.modules.jaxb.model.SchemaInfo;
import com.webcohesion.enunciate.modules.jaxb.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.util.JAXBCodeErrors;
import com.webcohesion.enunciate.modules.jaxrs.JaxrsModule;
import com.webcohesion.enunciate.modules.jaxws.JaxwsModule;
import com.webcohesion.enunciate.modules.jaxws.WsdlInfo;
import com.webcohesion.enunciate.modules.jaxws.model.EndpointInterface;
import com.webcohesion.enunciate.modules.jaxws.model.RequestWrapper;
import com.webcohesion.enunciate.modules.jaxws.model.ResponseWrapper;
import com.webcohesion.enunciate.modules.jaxws.model.WebFault;
import com.webcohesion.enunciate.modules.jaxws.model.WebMessage;
import com.webcohesion.enunciate.modules.jaxws.model.WebMethod;
import com.webcohesion.enunciate.util.AntPatternMatcher;
import com.webcohesion.enunciate.util.freemarker.AnnotationValueMethod;
import com.webcohesion.enunciate.util.freemarker.ClientPackageForMethod;
import com.webcohesion.enunciate.util.freemarker.FileDirective;
import com.webcohesion.enunciate.util.freemarker.FreemarkerUtil;
import com.webcohesion.enunciate.util.freemarker.IsFacetExcludedMethod;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import org.apache.commons.configuration.HierarchicalConfiguration;

public class JavaXMLClientModule
extends BasicGeneratingModule
implements ApiFeatureProviderModule,
ProjectExtensionModule {
    private static final String LIRBARY_DESCRIPTION_PROPERTY = "com.webcohesion.enunciate.modules.java_xml_client.EnunciateJavaXMLClientModule#LIRBARY_DESCRIPTION_PROPERTY";
    JaxbModule jaxbModule;
    JaxwsModule jaxwsModule;
    JaxrsModule jaxrsModule;

    public String getName() {
        return "java-xml-client";
    }

    public List<DependencySpec> getDependencySpecifications() {
        return Arrays.asList(new DependencySpec(){

            public boolean accept(EnunciateModule module) {
                if (module instanceof JaxbModule) {
                    JavaXMLClientModule.this.jaxbModule = (JaxbModule)module;
                    return true;
                }
                if (module instanceof JaxwsModule) {
                    JavaXMLClientModule.this.jaxwsModule = (JaxwsModule)module;
                    return true;
                }
                if (module instanceof JaxrsModule) {
                    JavaXMLClientModule.this.jaxrsModule = (JaxrsModule)module;
                    return true;
                }
                return module instanceof ApiRegistryProviderModule;
            }

            public boolean isFulfilled() {
                return true;
            }

            public String toString() {
                return "optional jaxb, optional jaxws, optional jaxrs";
            }
        });
    }

    public void call(EnunciateContext context) {
        if (this.jaxbModule == null || this.jaxbModule.getJaxbContext() == null || this.jaxbModule.getJaxbContext().getSchemas().isEmpty()) {
            this.info("No JAXB XML data types: Java XML client will not be generated.", new Object[0]);
            return;
        }
        List namingConflicts = JAXBCodeErrors.findConflictingAccessorNamingErrors((EnunciateJaxbContext)this.jaxbModule.getJaxbContext());
        if (namingConflicts != null && !namingConflicts.isEmpty()) {
            this.error("JAXB naming conflicts have been found:", new Object[0]);
            for (String namingConflict : namingConflicts) {
                this.error(namingConflict, new Object[0]);
            }
            this.error("These naming conflicts are often between the field and it's associated property, in which case you need to use one or two of the following strategies to avoid the conflicts:", new Object[0]);
            this.error("1. Explicitly exclude one or the other.", new Object[0]);
            this.error("2. Put the annotations on the property instead of the field.", new Object[0]);
            this.error("3. Tell JAXB to use a different process for detecting accessors using the @XmlAccessorType annotation.", new Object[0]);
            throw new EnunciateException("JAXB naming conflicts detected.");
        }
        File sourceDir = this.generateClientSources();
        File compileDir = this.compileClientSources(sourceDir);
        File resourcesDir = this.copyResources();
        this.packageArtifacts(sourceDir, resourcesDir, compileDir);
    }

    protected File generateClientSources() {
        File sourceDir = this.getSourceDir();
        sourceDir.mkdirs();
        HashMap<String, Object> model = new HashMap<String, Object>();
        Map<String, String> conversions = this.getClientPackageConversions();
        EnunciateJaxbContext jaxbContext = this.jaxbModule.getJaxbContext();
        model.put("packageFor", new ClientPackageForMethod(conversions, this.context));
        model.put("classnameFor", (Object)new ClientClassnameForMethod(conversions, jaxbContext));
        model.put("simpleNameFor", (Object)new SimpleNameForMethod(new ClientClassnameForMethod(conversions, jaxbContext, true)));
        model.put("file", new FileDirective(sourceDir, this.enunciate.getLogger()));
        model.put("generatedCodeLicense", this.enunciate.getConfiguration().readGeneratedCodeLicenseFile());
        model.put("annotationValue", new AnnotationValueMethod());
        TreeSet<String> facetIncludes = new TreeSet<String>(this.enunciate.getConfiguration().getFacetIncludes());
        facetIncludes.addAll(this.getFacetIncludes());
        TreeSet<String> facetExcludes = new TreeSet<String>(this.enunciate.getConfiguration().getFacetExcludes());
        facetExcludes.addAll(this.getFacetExcludes());
        FacetFilter facetFilter = new FacetFilter(facetIncludes, facetExcludes);
        model.put("isFacetExcluded", new IsFacetExcludedMethod(facetFilter));
        boolean upToDate = this.isUpToDateWithSources(sourceDir);
        if (!upToDate) {
            try {
                this.debug("Generating the Java client classes...", new Object[0]);
                HashMap<String, WebFault> allFaults = new HashMap<String, WebFault>();
                AntPatternMatcher matcher = new AntPatternMatcher();
                matcher.setPathSeparator(".");
                if (this.jaxwsModule != null) {
                    TreeSet<String> seeAlsos = new TreeSet<String>();
                    for (WsdlInfo wsdlInfo : this.jaxwsModule.getJaxwsContext().getWsdls().values()) {
                        for (EndpointInterface ei : wsdlInfo.getEndpointInterfaces()) {
                            if (!facetFilter.accept((HasFacets)ei)) continue;
                            for (WebMethod webMethod : ei.getWebMethods()) {
                                if (!facetFilter.accept((HasFacets)webMethod)) continue;
                                for (WebMessage webMessage : webMethod.getMessages()) {
                                    if (webMessage instanceof RequestWrapper) {
                                        model.put("message", webMessage);
                                        this.processTemplate(this.getTemplateURL("client-request-bean.fmt"), model);
                                        seeAlsos.add(this.getBeanName(new ClientClassnameForMethod(conversions, jaxbContext), ((RequestWrapper)webMessage).getRequestBeanName()));
                                        continue;
                                    }
                                    if (webMessage instanceof ResponseWrapper) {
                                        model.put("message", webMessage);
                                        this.processTemplate(this.getTemplateURL("client-response-bean.fmt"), model);
                                        seeAlsos.add(this.getBeanName(new ClientClassnameForMethod(conversions, jaxbContext), ((ResponseWrapper)webMessage).getResponseBeanName()));
                                        continue;
                                    }
                                    if (!(webMessage instanceof WebFault)) continue;
                                    WebFault fault = (WebFault)webMessage;
                                    allFaults.put(fault.getQualifiedName().toString(), fault);
                                }
                            }
                        }
                    }
                    for (WebFault webFault : allFaults.values()) {
                        boolean implicit = webFault.isImplicitSchemaElement();
                        String faultBean = implicit ? this.getBeanName(new ClientClassnameForMethod(conversions, jaxbContext), webFault.getImplicitFaultBeanQualifiedName()) : new ClientClassnameForMethod(conversions, jaxbContext).convert(webFault.getExplicitFaultBeanType());
                        seeAlsos.add(faultBean);
                        if (!implicit) continue;
                        model.put("fault", webFault);
                        this.processTemplate(this.getTemplateURL("client-fault-bean.fmt"), model);
                    }
                    model.put("seeAlsoBeans", seeAlsos);
                    model.put("baseUri", this.enunciate.getConfiguration().getApplicationRoot());
                    for (WsdlInfo wsdlInfo : this.jaxwsModule.getJaxwsContext().getWsdls().values()) {
                        if (wsdlInfo.getWsdlFile() == null) {
                            throw new EnunciateException("WSDL " + wsdlInfo.getId() + " doesn't have a filename.");
                        }
                        for (EndpointInterface ei : wsdlInfo.getEndpointInterfaces()) {
                            if (!facetFilter.accept((HasFacets)ei)) continue;
                            model.put("endpointInterface", ei);
                            model.put("wsdlFileName", wsdlInfo.getFilename());
                            this.processTemplate(this.getTemplateURL("client-endpoint-interface.fmt"), model);
                            this.processTemplate(this.getTemplateURL("client-soap-endpoint-impl.fmt"), model);
                        }
                    }
                    for (WebFault webFault : allFaults.values()) {
                        if (this.useServerSide((TypeElement)webFault, matcher)) {
                            this.copyServerSideType(sourceDir, (TypeElement)webFault);
                            continue;
                        }
                        TypeElement superFault = (TypeElement)((DeclaredType)webFault.getSuperclass()).asElement();
                        if (superFault != null && allFaults.containsKey(superFault.getQualifiedName().toString()) && ((WebFault)allFaults.get(superFault.getQualifiedName().toString())).isImplicitSchemaElement()) {
                            model.put("superFault", allFaults.get(superFault.getQualifiedName().toString()));
                        } else {
                            model.remove("superFault");
                        }
                        model.put("fault", webFault);
                        this.processTemplate(this.getTemplateURL("client-web-fault.fmt"), model);
                    }
                }
                for (SchemaInfo schemaInfo : this.jaxbModule.getJaxbContext().getSchemas().values()) {
                    for (TypeDefinition typeDefinition : schemaInfo.getTypeDefinitions()) {
                        if (!facetFilter.accept((HasFacets)typeDefinition)) continue;
                        if (this.useServerSide((TypeElement)typeDefinition, matcher)) {
                            this.copyServerSideType(sourceDir, (TypeElement)typeDefinition);
                            continue;
                        }
                        model.put("rootEl", this.jaxbModule.getJaxbContext().findElementDeclaration((Element)typeDefinition));
                        model.put("type", typeDefinition);
                        URL template = typeDefinition.isEnum() ? (typeDefinition instanceof QNameEnumTypeDefinition ? this.getTemplateURL("client-qname-enum-type.fmt") : this.getTemplateURL("client-enum-type.fmt")) : (typeDefinition.isSimple() ? this.getTemplateURL("client-simple-type.fmt") : this.getTemplateURL("client-complex-type.fmt"));
                        this.processTemplate(template, model);
                    }
                    for (Registry registry : schemaInfo.getRegistries()) {
                        model.put("registry", registry);
                        this.processTemplate(this.getTemplateURL("client-registry.fmt"), model);
                    }
                }
            }
            catch (IOException e) {
                throw new EnunciateException((Throwable)e);
            }
            catch (TemplateException e) {
                throw new EnunciateException((Throwable)e);
            }
        } else {
            this.info("Skipping generation of Java client sources as everything appears up-to-date...", new Object[0]);
        }
        this.context.setProperty(LIRBARY_DESCRIPTION_PROPERTY, (Object)this.readLibraryDescription(model));
        return sourceDir;
    }

    protected void copyServerSideType(File sourceDir, TypeElement type) throws IOException {
        SourcePosition source = this.context.getProcessingEnvironment().findSourcePosition((Element)type);
        JavaFileObject sourceFile = source.getSourceFile();
        File destFile = this.getServerSideDestFile(sourceDir, sourceFile, type);
        FileWriter writer = new FileWriter(destFile);
        this.debug("Writing server-side java type to %s.", new Object[]{destFile});
        writer.write(sourceFile.getCharContent(false).toString());
        writer.flush();
        writer.close();
    }

    protected File getSourceDir() {
        return new File(new File(this.enunciate.getBuildDir(), this.getName()), "src");
    }

    public String processTemplate(URL templateURL, Object model) throws IOException, TemplateException {
        this.debug("Processing template %s.", new Object[]{templateURL});
        Configuration configuration = new Configuration(FreemarkerUtil.VERSION);
        configuration.setLocale(new Locale("en", "US"));
        configuration.setTemplateLoader((TemplateLoader)new URLTemplateLoader(){

            protected URL getURL(String name) {
                try {
                    return new URL(name);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        });
        configuration.setTemplateExceptionHandler(new TemplateExceptionHandler(){

            public void handleTemplateException(TemplateException templateException, Environment environment, Writer writer) throws TemplateException {
                throw templateException;
            }
        });
        configuration.setLocalizedLookup(false);
        configuration.setDefaultEncoding("UTF-8");
        configuration.setObjectWrapper((ObjectWrapper)new JavaXMLClientObjectWrapper());
        Template template = configuration.getTemplate(templateURL.toString());
        StringWriter unhandledOutput = new StringWriter();
        template.process(model, (Writer)unhandledOutput);
        unhandledOutput.close();
        return unhandledOutput.toString();
    }

    protected File getServerSideDestFile(File sourceDir, JavaFileObject sourceFile, TypeElement declaration) {
        File destDir = sourceDir;
        String packageName = this.context.getProcessingEnvironment().getElementUtils().getPackageOf(declaration).getQualifiedName().toString();
        StringTokenizer packagePaths = new StringTokenizer(packageName, ".");
        while (packagePaths.hasMoreTokens()) {
            String packagePath = packagePaths.nextToken();
            destDir = new File(destDir, packagePath);
        }
        destDir.mkdirs();
        String simpleFilename = sourceFile.toUri().toString();
        simpleFilename = simpleFilename.substring(simpleFilename.lastIndexOf(47));
        return new File(destDir, simpleFilename);
    }

    protected boolean useServerSide(TypeElement declaration, AntPatternMatcher matcher) {
        boolean useServerSide = false;
        for (String pattern : this.getServerSideTypesToUse()) {
            if (!matcher.match(pattern, declaration.getQualifiedName().toString())) continue;
            useServerSide = true;
            break;
        }
        return useServerSide;
    }

    protected String getBeanName(ClientClassnameForMethod conversion, String preconvert) {
        String pckg = conversion.convert(preconvert.substring(0, preconvert.lastIndexOf(46)));
        String simpleName = preconvert.substring(preconvert.lastIndexOf(46) + 1);
        return pckg + "." + simpleName;
    }

    protected File compileClientSources(File sourceDir) {
        File compileDir = this.getCompileDir();
        compileDir.mkdirs();
        if (!this.isDisableCompile()) {
            if (!this.isUpToDateWithSources(compileDir)) {
                List<File> sources = this.findJavaFiles(sourceDir);
                if (sources != null && !sources.isEmpty()) {
                    List<String> options;
                    String classpath = this.enunciate.writeClasspath(this.enunciate.getClasspath());
                    JavacTool compiler = JavacTool.create();
                    JavaCompiler.CompilationTask task = compiler.getTask(null, null, null, options = Arrays.asList("-source", this.getJavacSource(), "-target", this.getJavacTarget(), "-encoding", "UTF-8", "-cp", classpath, "-d", compileDir.getAbsolutePath(), "-nowarn"), null, compiler.getStandardFileManager(null, null, null).getJavaFileObjectsFromFiles(sources));
                    if (!task.call().booleanValue()) {
                        throw new EnunciateException("Compile failed of Java client-side classes.");
                    }
                } else {
                    this.debug("No Java XML client classes to compile.", new Object[0]);
                }
            } else {
                this.info("Skipping compilation of Java client classes as everything appears up-to-date...", new Object[0]);
            }
        }
        return compileDir;
    }

    private List<File> findJavaFiles(File sourceDir) {
        final ArrayList<File> javaFiles = new ArrayList<File>();
        this.enunciate.visitFiles(sourceDir, Enunciate.JAVA_FILTER, new Enunciate.FileVisitor(){

            public void visit(File file) {
                javaFiles.add(file);
            }
        });
        return javaFiles;
    }

    protected File getCompileDir() {
        return new File(new File(this.enunciate.getBuildDir(), this.getName()), "classes");
    }

    protected File copyResources() {
        File resourcesDir = this.getResourcesDir();
        resourcesDir.mkdirs();
        try {
            if (this.jaxwsModule != null) {
                for (WsdlInfo wsdlInfo : this.jaxwsModule.getJaxwsContext().getWsdls().values()) {
                    if (wsdlInfo.getWsdlFile() == null) continue;
                    wsdlInfo.getWsdlFile().writeTo(resourcesDir);
                }
            }
            for (SchemaInfo schemaInfo : this.jaxbModule.getJaxbContext().getSchemas().values()) {
                if (schemaInfo.getSchemaFile() == null) continue;
                schemaInfo.getSchemaFile().writeTo(resourcesDir);
            }
        }
        catch (IOException e) {
            throw new EnunciateException((Throwable)e);
        }
        return resourcesDir;
    }

    protected File getResourcesDir() {
        return new File(new File(this.enunciate.getBuildDir(), this.getName()), "resources");
    }

    protected File packageArtifacts(File sourceDir, File resourcesDir, File compileDir) {
        File packageDir = this.getPackageDir();
        packageDir.mkdirs();
        try {
            String jarName = this.getJarName();
            File clientJarFile = null;
            if (!this.isDisableCompile()) {
                clientJarFile = new File(packageDir, jarName);
                if (!this.isUpToDateWithSources(clientJarFile)) {
                    boolean anyFiles;
                    if (this.isBundleSourcesWithClasses()) {
                        anyFiles = this.enunciate.jar(clientJarFile, this.getManifest(), new File[]{sourceDir, resourcesDir, compileDir});
                        if (!anyFiles) {
                            clientJarFile = null;
                        }
                    } else {
                        anyFiles = this.enunciate.jar(clientJarFile, this.getManifest(), new File[]{resourcesDir, compileDir});
                        if (!anyFiles) {
                            clientJarFile = null;
                        }
                    }
                } else {
                    this.info("Skipping creation of Java client jar as everything appears up-to-date...", new Object[0]);
                }
            }
            File clientSourcesJarFile = null;
            if (!this.isBundleSourcesWithClasses()) {
                clientSourcesJarFile = new File(packageDir, jarName.replaceFirst("\\.jar", "-xml-sources.jar"));
                if (!this.isUpToDateWithSources(clientSourcesJarFile)) {
                    boolean anyFiles = this.enunciate.zip(clientSourcesJarFile, new File[]{sourceDir, resourcesDir});
                    if (!anyFiles) {
                        clientSourcesJarFile = null;
                    }
                } else {
                    this.info("Skipping creation of the Java client source jar as everything appears up-to-date...", new Object[0]);
                }
            }
            ClientLibraryJavaArtifact artifactBundle = new ClientLibraryJavaArtifact(this.getName(), "java.xml.client.library", "Java XML Client Library");
            artifactBundle.setGroupId(this.getGroupId());
            artifactBundle.setArtifactId(this.getArtifactId());
            artifactBundle.setVersion(this.getVersion());
            artifactBundle.setPlatform("Java (Version 5+)");
            artifactBundle.setDescription((String)this.context.getProperty(LIRBARY_DESCRIPTION_PROPERTY));
            if (clientJarFile != null) {
                FileArtifact binariesJar = new FileArtifact(this.getName(), "java.xml.client.library.binaries", clientJarFile);
                binariesJar.setDescription("The binaries for the Java XML client library.");
                binariesJar.setPublic(false);
                binariesJar.setArtifactType(ArtifactType.binaries);
                artifactBundle.addArtifact(binariesJar);
                this.enunciate.addArtifact((Artifact)binariesJar);
            }
            if (clientSourcesJarFile != null) {
                FileArtifact sourcesJar = new FileArtifact(this.getName(), "java.xml.client.library.sources", clientSourcesJarFile);
                sourcesJar.setDescription("The sources for the Java XML client library.");
                sourcesJar.setPublic(false);
                sourcesJar.setArtifactType(ArtifactType.sources);
                artifactBundle.addArtifact(sourcesJar);
                this.enunciate.addArtifact((Artifact)sourcesJar);
            }
            if (clientJarFile != null || clientSourcesJarFile != null) {
                this.enunciate.addArtifact((Artifact)artifactBundle);
            }
        }
        catch (IOException e) {
            throw new EnunciateException((Throwable)e);
        }
        return packageDir;
    }

    protected File getPackageDir() {
        return new File(new File(this.enunciate.getBuildDir(), this.getName()), "build");
    }

    protected String readLibraryDescription(Map<String, Object> model) {
        model.put("sample_service_method", this.findExampleWebMethod());
        model.put("sample_resource", this.findExampleResourceMethod());
        model.put("mediaTypeFor", new MediaTypeForMethod());
        URL res = JavaXMLClientModule.class.getResource("library_description.fmt");
        try {
            return this.processTemplate(res, model);
        }
        catch (TemplateException e) {
            throw new EnunciateException((Throwable)e);
        }
        catch (IOException e) {
            throw new EnunciateException((Throwable)e);
        }
    }

    public WebMethod findExampleWebMethod() {
        WebMethod example = null;
        if (this.jaxwsModule != null) {
            for (EndpointInterface ei : this.jaxwsModule.getJaxwsContext().getEndpointInterfaces()) {
                for (WebMethod method : ei.getWebMethods()) {
                    if (method.getAnnotation(DocumentationExample.class) != null && !((DocumentationExample)method.getAnnotation(DocumentationExample.class)).exclude()) {
                        return method;
                    }
                    if (method.getJavaDoc().get((Object)"documentationExample") != null) {
                        return method;
                    }
                    if (method.getWebResult() != null && method.getWebResult().getType() instanceof DeclaredType && (example == null || example.getWebResult() == null || !(example.getWebResult().getType() instanceof DeclaredType))) {
                        example = method;
                        continue;
                    }
                    example = example == null ? method : example;
                }
            }
        }
        return example;
    }

    public Method findExampleResourceMethod() {
        Method example = null;
        if (this.jaxrsModule != null) {
            List resourceGroups = this.jaxrsModule.getJaxrsContext().getResourceGroups((ApiRegistrationContext)new DefaultRegistrationContext(this.context));
            for (ResourceGroup resourceGroup : resourceGroups) {
                List resources = resourceGroup.getResources();
                for (Resource resource : resources) {
                    for (Method method : resource.getMethods()) {
                        if (!this.hasXmlResponseEntity(method)) continue;
                        if (this.hasXmlRequestEntity(method)) {
                            return method;
                        }
                        example = example == null ? method : example;
                    }
                }
            }
        }
        return example;
    }

    private boolean hasXmlResponseEntity(Method method) {
        if (method.getResponseEntity() != null) {
            for (MediaTypeDescriptor mediaTypeDescriptor : method.getResponseEntity().getMediaTypes()) {
                if (!"XML".equals(mediaTypeDescriptor.getSyntax())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasXmlRequestEntity(Method method) {
        if (method.getRequestEntity() != null) {
            for (MediaTypeDescriptor mediaTypeDescriptor : method.getRequestEntity().getMediaTypes()) {
                if (!"XML".equals(mediaTypeDescriptor.getSyntax())) continue;
                return true;
            }
        }
        return false;
    }

    protected URL getTemplateURL(String template) {
        return JavaXMLClientModule.class.getResource(template);
    }

    public String getJarName() {
        return this.config.getString("[@jarName]", this.getSlug() + "-xml-client.jar");
    }

    public Map<String, String> getClientPackageConversions() {
        List conversionElements = this.config.configurationsAt("package-conversions.convert");
        HashMap<String, String> conversions = new HashMap<String, String>();
        conversions.put("java.lang.Exception", "client.java.lang.Exception");
        for (HierarchicalConfiguration conversionElement : conversionElements) {
            conversions.put(conversionElement.getString("[@from]"), conversionElement.getString("[@to]"));
        }
        return conversions;
    }

    public Set<String> getServerSideTypesToUse() {
        List typeElements = this.config.configurationsAt("server-side-type");
        TreeSet<String> types = new TreeSet<String>();
        for (HierarchicalConfiguration typeElement : typeElements) {
            types.add(typeElement.getString("[@pattern]"));
        }
        return types;
    }

    public String getSlug() {
        return this.config.getString("[@slug]", this.enunciate.getConfiguration().getSlug());
    }

    public boolean isBundleSourcesWithClasses() {
        return this.config.getBoolean("[@bundleSourcesWithClasses]", false);
    }

    public String getGroupId() {
        return this.config.getString("[@groupId]", null);
    }

    public String getArtifactId() {
        return this.config.getString("[@artifactId]", null);
    }

    public String getVersion() {
        return this.config.getString("[@version]", null);
    }

    public String getJavacSource() {
        return this.config.getString("[@javac-source]", "1.6");
    }

    public String getJavacTarget() {
        return this.config.getString("[@javac-target]", "1.6");
    }

    public List<File> getProjectSources() {
        return Collections.emptyList();
    }

    public List<File> getProjectTestSources() {
        return Arrays.asList(this.getSourceDir());
    }

    public List<File> getProjectResourceDirectories() {
        return Collections.emptyList();
    }

    public List<File> getProjectTestResourceDirectories() {
        return Arrays.asList(this.getResourcesDir());
    }

    public boolean isDisableCompile() {
        return this.config.getBoolean("[@disableCompile]", false);
    }

    public Set<String> getFacetIncludes() {
        List includes = this.config.getList("facets.include[@name]");
        TreeSet<String> facetIncludes = new TreeSet<String>();
        for (Object include : includes) {
            facetIncludes.add(String.valueOf(include));
        }
        return facetIncludes;
    }

    public Set<String> getFacetExcludes() {
        List excludes = this.config.getList("facets.exclude[@name]");
        TreeSet<String> facetExcludes = new TreeSet<String>();
        for (Object exclude : excludes) {
            facetExcludes.add(String.valueOf(exclude));
        }
        return facetExcludes;
    }
}

