/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.java_json_client;

import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.resources.Entity;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.metadata.ClientName;
import com.webcohesion.enunciate.metadata.qname.XmlQNameEnumRef;
import com.webcohesion.enunciate.modules.java_json_client.MergedJsonContext;
import com.webcohesion.enunciate.util.HasClientConvertibleType;
import freemarker.template.TemplateModelException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.xml.bind.JAXBElement;

public class ClientClassnameForMethod
extends com.webcohesion.enunciate.util.freemarker.ClientClassnameForMethod {
    protected final LinkedList<String> recursiveMapStack = new LinkedList();
    private final MergedJsonContext jsonContext;

    public ClientClassnameForMethod(Map<String, String> conversions, MergedJsonContext context) {
        super(conversions, context.getContext());
        this.jsonContext = context;
    }

    public String convertUnwrappedObject(Object unwrapped) throws TemplateModelException {
        if (unwrapped instanceof Entity) {
            List mediaTypes = ((Entity)unwrapped).getMediaTypes();
            for (MediaTypeDescriptor mediaType : mediaTypes) {
                if (!this.jsonContext.getLabel().equals(mediaType.getSyntax())) continue;
                DataTypeReference dataType = mediaType.getDataType();
                return super.convertUnwrappedObject((Object)this.jsonContext.findType(dataType));
            }
            return "byte[]";
        }
        return super.convertUnwrappedObject(unwrapped);
    }

    public String convert(HasClientConvertibleType element) throws TemplateModelException {
        TypeMirror adaptingType = this.jsonContext.findAdaptingType(element);
        if (adaptingType != null) {
            return this.convert(adaptingType);
        }
        if (element instanceof Element && ((Element)element).getAnnotation(XmlQNameEnumRef.class) != null) {
            return "String";
        }
        return super.convert(element);
    }

    public String convert(TypeElement declaration) throws TemplateModelException {
        DecoratedTypeMirror superType;
        TypeMirror adaptingType = this.jsonContext.findAdaptingType(declaration);
        if (adaptingType != null) {
            return this.convert(adaptingType);
        }
        if (declaration.getKind() == ElementKind.CLASS && (superType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)declaration.getSuperclass(), (ProcessingEnvironment)this.context.getProcessingEnvironment())) != null && superType.isInstanceOf(JAXBElement.class.getName())) {
            return this.convert((TypeMirror)superType);
        }
        String convertedPackage = this.convertPackage(this.context.getProcessingEnvironment().getElementUtils().getPackageOf(declaration));
        ClientName specifiedName = declaration.getAnnotation(ClientName.class);
        String simpleName = specifiedName == null ? declaration.getSimpleName().toString() : specifiedName.value();
        return convertedPackage + this.getPackageSeparator() + simpleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convert(TypeMirror typeMirror) throws TemplateModelException {
        DeclaredType mapType = this.jsonContext.findMapType(typeMirror);
        if (mapType != null) {
            String fqn = typeMirror.toString();
            if (this.recursiveMapStack.contains(fqn)) {
                return "java.lang.Object";
            }
            this.recursiveMapStack.push(fqn);
            try {
                String string = super.convert((TypeMirror)mapType);
                return string;
            }
            finally {
                this.recursiveMapStack.pop();
            }
        }
        return super.convert(typeMirror);
    }
}

