/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security;

import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import java.util.Objects;
import java.util.Set;

public class WebAuthnRegistrationRequestValidationResponse {
    private final CollectedClientData collectedClientData;
    private final AttestationObject attestationObject;
    private final AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> registrationExtensionsClientOutputs;
    private final Set<AuthenticatorTransport> transports;

    public WebAuthnRegistrationRequestValidationResponse(CollectedClientData collectedClientData, AttestationObject attestationObject, AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> registrationExtensionsClientOutputs, Set<AuthenticatorTransport> transports) {
        this.collectedClientData = collectedClientData;
        this.attestationObject = attestationObject;
        this.registrationExtensionsClientOutputs = registrationExtensionsClientOutputs;
        this.transports = transports;
    }

    public CollectedClientData getCollectedClientData() {
        return this.collectedClientData;
    }

    public AttestationObject getAttestationObject() {
        return this.attestationObject;
    }

    public AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> getRegistrationExtensionsClientOutputs() {
        return this.registrationExtensionsClientOutputs;
    }

    public Set<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebAuthnRegistrationRequestValidationResponse that = (WebAuthnRegistrationRequestValidationResponse)o;
        return Objects.equals(this.collectedClientData, that.collectedClientData) && Objects.equals(this.attestationObject, that.attestationObject) && Objects.equals(this.registrationExtensionsClientOutputs, that.registrationExtensionsClientOutputs) && Objects.equals(this.transports, that.transports);
    }

    public int hashCode() {
        return Objects.hash(this.collectedClientData, this.attestationObject, this.registrationExtensionsClientOutputs, this.transports);
    }
}

