/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security;

import com.webauthn4j.server.ServerProperty;
import java.io.Serializable;
import java.util.Objects;

public class WebAuthnAuthenticationParameters
implements Serializable {
    private final ServerProperty serverProperty;
    private final boolean userVerificationRequired;
    private final boolean userPresenceRequired;

    public WebAuthnAuthenticationParameters(ServerProperty serverProperty, boolean userVerificationRequired, boolean userPresenceRequired) {
        this.serverProperty = serverProperty;
        this.userVerificationRequired = userVerificationRequired;
        this.userPresenceRequired = userPresenceRequired;
    }

    public ServerProperty getServerProperty() {
        return this.serverProperty;
    }

    public boolean isUserVerificationRequired() {
        return this.userVerificationRequired;
    }

    public boolean isUserPresenceRequired() {
        return this.userPresenceRequired;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebAuthnAuthenticationParameters that = (WebAuthnAuthenticationParameters)o;
        return this.userVerificationRequired == that.userVerificationRequired && this.userPresenceRequired == that.userPresenceRequired && Objects.equals(this.serverProperty, that.serverProperty);
    }

    public int hashCode() {
        return Objects.hash(this.serverProperty, this.userVerificationRequired, this.userPresenceRequired);
    }
}

