/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.flow.execution.entrance.restful;

import com.webank.wedatasphere.dss.flow.execution.entrance.FlowContext$;
import com.webank.wedatasphere.dss.flow.execution.entrance.entity.WorkflowExecuteInfoVo;
import com.webank.wedatasphere.dss.flow.execution.entrance.job.FlowEntranceJob;
import com.webank.wedatasphere.dss.flow.execution.entrance.service.WorkflowExecutionInfoService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.linkis.entrance.EntranceServer;
import org.apache.linkis.entrance.annotation.EntranceServerBeanAnnotation;
import org.apache.linkis.protocol.utils.ZuulEntranceUtils;
import org.apache.linkis.scheduler.queue.Job;
import org.apache.linkis.scheduler.queue.SchedulerEventState;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.apache.linkis.server.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import scala.Enumeration;
import scala.Option;

@RequestMapping(path={"/dss/flow/entrance"})
@RestController
public class FlowExecutionRestfulApi {
    private EntranceServer entranceServer;
    private static final Logger logger = LoggerFactory.getLogger(FlowExecutionRestfulApi.class);
    @Autowired
    private WorkflowExecutionInfoService workflowExecutionInfoService;

    @EntranceServerBeanAnnotation.EntranceServerAutowiredAnnotation
    public void setEntranceServer(EntranceServer entranceServer) {
        this.entranceServer = entranceServer;
    }

    @RequestMapping(value={"/{id}/execution"}, method={RequestMethod.GET})
    public Message execution(@PathVariable(value="id") String id, @RequestParam(value="labels") String labels) {
        Message message = null;
        String realId = ZuulEntranceUtils.parseExecID((String)id)[3];
        Option job = this.entranceServer.getJob(realId);
        try {
            if (job.isDefined() && job.get() instanceof FlowEntranceJob) {
                logger.info("Start to get job {} execution info", (Object)((Job)job.get()).getId());
                FlowEntranceJob flowEntranceJob = (FlowEntranceJob)job.get();
                message = Message.ok((String)"Successfully get job execution info");
                message.setMethod("/api/entrance/" + id + "/execution");
                message.setStatus(0);
                long nowTime = System.currentTimeMillis();
                flowEntranceJob.getFlowContext().getRunningNodes().forEach((k, v) -> {
                    if (v != null) {
                        v.setNowTime(nowTime);
                    }
                });
                List<Map<String, Object>> runningJobsList = FlowContext$.MODULE$.convertView(flowEntranceJob.getFlowContext().getRunningNodes());
                message.data("runningJobs", runningJobsList);
                List<Map<String, Object>> pendingList = FlowContext$.MODULE$.convertView(flowEntranceJob.getFlowContext().getPendingNodes());
                pendingList.addAll(FlowContext$.MODULE$.convertView(flowEntranceJob.getFlowContext().getSkippedNodes()));
                message.data("pendingJobs", pendingList);
                List<Map<String, Object>> succeedJobsList = FlowContext$.MODULE$.convertView(flowEntranceJob.getFlowContext().getSucceedNodes());
                message.data("succeedJobs", succeedJobsList);
                List<Map<String, Object>> failedJobsList = FlowContext$.MODULE$.convertView(flowEntranceJob.getFlowContext().getFailedNodes());
                message.data("failedJobs", failedJobsList);
                List<Map<String, Object>> skippedJobsList = FlowContext$.MODULE$.convertView(flowEntranceJob.getFlowContext().getSkippedNodes());
                message.data("skippedJobs", skippedJobsList);
                int status = this.getJobStatus(flowEntranceJob);
                if (status < 2) {
                    WorkflowExecuteInfoVo workflowExecuteInfoVo = new WorkflowExecuteInfoVo();
                    workflowExecuteInfoVo.setTaskId(flowEntranceJob.getJobRequest().getId());
                    String flowIdStr = ((Map)BDPJettyServerHelper.jacksonJson().readValue(flowEntranceJob.getJobRequest().getExecutionCode(), Map.class)).get("flowId").toString();
                    String version = ((Map)BDPJettyServerHelper.jacksonJson().readValue(flowEntranceJob.getJobRequest().getExecutionCode(), Map.class)).get("version").toString();
                    workflowExecuteInfoVo.setFlowId(Long.parseLong(flowIdStr));
                    workflowExecuteInfoVo.setVersion(version);
                    workflowExecuteInfoVo.setFailedJobsList(failedJobsList);
                    workflowExecuteInfoVo.setPendingJobsList(pendingList);
                    workflowExecuteInfoVo.setSkippedJobsList(skippedJobsList);
                    workflowExecuteInfoVo.setRunningJobsList(runningJobsList);
                    workflowExecuteInfoVo.setSucceedJobsList(succeedJobsList);
                    workflowExecuteInfoVo.setCreatetime(new Date());
                    workflowExecuteInfoVo.setStatus(status);
                    this.workflowExecutionInfoService.saveExecuteInfo(workflowExecuteInfoVo);
                }
            } else {
                message = Message.error((String)"ID The corresponding job is empty and cannot obtain the corresponding task status.(ID \u5bf9\u5e94\u7684job\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u83b7\u53d6\u76f8\u5e94\u7684\u4efb\u52a1\u72b6\u6001)");
            }
        }
        catch (Exception e) {
            logger.error("Failed to get job execution info:", (Throwable)e);
            message = Message.error((String)("Failed to get job execution info:" + e.getMessage()));
        }
        return message;
    }

    private int getJobStatus(FlowEntranceJob flowEntranceJob) {
        Enumeration.Value state = flowEntranceJob.getState();
        int status = 2;
        if (SchedulerEventState.Failed().equals((Object)state) || SchedulerEventState.Cancelled().equals((Object)state) || SchedulerEventState.Timeout().equals((Object)state)) {
            status = 0;
        } else if (SchedulerEventState.Succeed().equals((Object)state)) {
            status = 1;
        }
        return status;
    }
}

