/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.flow.execution.entrance.restful;

import com.webank.wedatasphere.dss.flow.execution.entrance.FlowContext$;
import com.webank.wedatasphere.dss.flow.execution.entrance.job.FlowEntranceJob;
import java.util.List;
import java.util.Map;
import org.apache.linkis.entrance.EntranceServer;
import org.apache.linkis.entrance.annotation.EntranceServerBeanAnnotation;
import org.apache.linkis.protocol.utils.ZuulEntranceUtils;
import org.apache.linkis.scheduler.queue.Job;
import org.apache.linkis.server.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import scala.Option;

@RequestMapping(path={"/dss/flow/entrance"})
@RestController
public class FlowExecutionRestfulApi {
    private EntranceServer entranceServer;
    private static final Logger logger = LoggerFactory.getLogger(FlowExecutionRestfulApi.class);

    @EntranceServerBeanAnnotation.EntranceServerAutowiredAnnotation
    public void setEntranceServer(EntranceServer entranceServer) {
        this.entranceServer = entranceServer;
    }

    @RequestMapping(value={"/{id}/execution"}, method={RequestMethod.GET})
    public Message execution(@PathVariable(value="id") String id, @RequestParam(value="labels") String labels) {
        Message message = null;
        String realId = ZuulEntranceUtils.parseExecID((String)id)[3];
        Option job = this.entranceServer.getJob(realId);
        try {
            if (job.isDefined() && job.get() instanceof FlowEntranceJob) {
                logger.info("Start to get job {} execution info", (Object)((Job)job.get()).getId());
                FlowEntranceJob flowEntranceJob = (FlowEntranceJob)job.get();
                message = Message.ok((String)"Successfully get job execution info");
                message.setMethod("/api/entrance/" + id + "/execution");
                message.setStatus(0);
                long nowTime = System.currentTimeMillis();
                flowEntranceJob.getFlowContext().getRunningNodes().forEach((k, v) -> {
                    if (v != null) {
                        v.setNowTime(nowTime);
                    }
                });
                message.data("runningJobs", FlowContext$.MODULE$.convertView(flowEntranceJob.getFlowContext().getRunningNodes()));
                List<Map<String, Object>> pendingList = FlowContext$.MODULE$.convertView(flowEntranceJob.getFlowContext().getPendingNodes());
                pendingList.addAll(FlowContext$.MODULE$.convertView(flowEntranceJob.getFlowContext().getSkippedNodes()));
                message.data("pendingJobs", pendingList);
                message.data("succeedJobs", FlowContext$.MODULE$.convertView(flowEntranceJob.getFlowContext().getSucceedNodes()));
                message.data("failedJobs", FlowContext$.MODULE$.convertView(flowEntranceJob.getFlowContext().getFailedNodes()));
                message.data("skippedJobs", FlowContext$.MODULE$.convertView(flowEntranceJob.getFlowContext().getSkippedNodes()));
            } else {
                message = Message.error((String)"ID The corresponding job is empty and cannot obtain the corresponding task status.(ID \u5bf9\u5e94\u7684job\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u83b7\u53d6\u76f8\u5e94\u7684\u4efb\u52a1\u72b6\u6001)");
            }
        }
        catch (Exception e) {
            message = Message.error((String)"Failed to get job execution info");
        }
        return message;
    }
}

