/*
 * Copyright 2019 WeBank
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.webank.wedatasphere.dss.flow.execution.entrance.log


import com.webank.wedatasphere.dss.flow.execution.entrance.conf.FlowExecutionEntranceConfiguration
import com.webank.wedatasphere.dss.linkis.node.execution.log.LinkisJobExecutionLog
import org.apache.linkis.common.utils.Logging


class FlowExecutionLog(log:Logging) extends LinkisJobExecutionLog {
  override def info(message: scala.Any, t: Throwable): Unit = {
    if(message != null && FlowExecutionEntranceConfiguration.NODE_PRINT_FLAG.getValue) log.info(message.toString, t)
  }

  override def warn(message: scala.Any, t: Throwable): Unit = {
    if(message != null && FlowExecutionEntranceConfiguration.NODE_PRINT_FLAG.getValue) log.warn(message.toString, t)
  }

  override def error(message: scala.Any, t: Throwable): Unit = {
    if(message != null && FlowExecutionEntranceConfiguration.NODE_PRINT_FLAG.getValue) log.error(message.toString, t)
  }
}
