/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.spring.autoconfigure;

import com.wavefront.sdk.common.Utils;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.spring.account.AccountInfo;
import com.wavefront.spring.account.AccountManagementClient;
import com.wavefront.spring.autoconfigure.AccountManagementEnablementDeducer;
import com.wavefront.spring.autoconfigure.ApplicationTagsFactory;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.context.event.SpringApplicationEvent;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.PathResource;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class AccountManagementEnvironmentPostProcessor
implements EnvironmentPostProcessor,
ApplicationListener<SpringApplicationEvent> {
    private static final String ENABLED_PROPERTY = "management.wavefront.metrics.export.enabled";
    private static final String API_TOKEN_PROPERTY = "management.wavefront.api-token";
    private static final String URI_PROPERTY = "management.wavefront.uri";
    public static final String FREEMIUM_ACCOUNT_PROPERTY = "wavefront.freemium-account";
    private static final String DEFAULT_CLUSTER_URI = "https://wavefront.surf";
    private final DeferredLog logger = new DeferredLog();
    private Supplier<String> accountConfigurationOutcome;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!this.shouldRun(environment)) {
            return;
        }
        application.addListeners(new ApplicationListener[]{this});
        String clusterUri = environment.getProperty(URI_PROPERTY, DEFAULT_CLUSTER_URI);
        if (!this.isApiTokenRequired(environment)) {
            this.accountConfigurationOutcome = this.validateExistingConfiguration(environment, clusterUri);
            return;
        }
        Resource localApiTokenResource = this.getLocalApiTokenResource();
        String existingApiToken = this.readExistingApiToken(localApiTokenResource);
        this.accountConfigurationOutcome = existingApiToken != null ? this.configureExistingAccount(environment, clusterUri, existingApiToken, localApiTokenResource) : this.configureNewAccount(environment, clusterUri, localApiTokenResource);
    }

    private boolean shouldRun(ConfigurableEnvironment environment) {
        if (environment.getPropertySources().contains("bootstrap")) {
            return false;
        }
        Boolean freemiumAccount = (Boolean)environment.getProperty(FREEMIUM_ACCOUNT_PROPERTY, Boolean.class);
        if (freemiumAccount != null) {
            return freemiumAccount;
        }
        if (!this.shouldEnableAccountManagement(Thread.currentThread())) {
            return false;
        }
        return (Boolean)environment.getProperty(ENABLED_PROPERTY, Boolean.class, (Object)true);
    }

    public void onApplicationEvent(@NonNull SpringApplicationEvent event) {
        if (event instanceof ApplicationPreparedEvent) {
            this.logger.switchTo(AccountManagementEnvironmentPostProcessor.class);
        }
        if ((event instanceof ApplicationStartedEvent || event instanceof ApplicationFailedEvent) && this.accountConfigurationOutcome != null) {
            System.out.println(this.accountConfigurationOutcome.get());
        }
    }

    private boolean isApiTokenRequired(ConfigurableEnvironment environment) {
        String apiToken = environment.getProperty(API_TOKEN_PROPERTY);
        if (StringUtils.hasText((String)apiToken)) {
            this.logger.debug((Object)"Wavefront api token already set, no need to negotiate one");
            return false;
        }
        URI uri = (URI)environment.getProperty(URI_PROPERTY, URI.class);
        if (uri != null && "proxy".equals(uri.getScheme())) {
            this.logger.debug((Object)"Pushing to a Wavefront proxy does not require an api token.");
            return false;
        }
        return true;
    }

    private Supplier<String> validateExistingConfiguration(ConfigurableEnvironment environment, String clusterUri) {
        Boolean freemiumAccount = (Boolean)environment.getProperty(FREEMIUM_ACCOUNT_PROPERTY, Boolean.TYPE, (Object)false);
        String apiToken = environment.getProperty(API_TOKEN_PROPERTY);
        if (!freemiumAccount.booleanValue() || !StringUtils.hasText((String)apiToken)) {
            return null;
        }
        try {
            AccountInfo accountInfo = this.invokeAccountManagementClient(environment, (client, applicationTags) -> this.getExistingAccount((AccountManagementClient)client, clusterUri, (ApplicationTags)applicationTags, apiToken));
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%nConnect to your Wavefront dashboard using this one-time use link:%n%s%n", accountInfo.loginUrl()));
            return sb::toString;
        }
        catch (Exception ex) {
            return this.accountManagementFailure(String.format("Failed to retrieve existing account information from %s.", clusterUri), ex.getMessage());
        }
    }

    private Supplier<String> configureExistingAccount(ConfigurableEnvironment environment, String clusterUri, String apiToken, Resource localApiTokenResource) {
        try {
            this.logger.debug((Object)("Existing Wavefront api token found from " + localApiTokenResource));
            this.registerApiToken(environment, apiToken);
            AccountInfo accountInfo = this.invokeAccountManagementClient(environment, (client, applicationTags) -> this.getExistingAccount((AccountManagementClient)client, clusterUri, (ApplicationTags)applicationTags, apiToken));
            return this.accountManagementSuccess("Your existing Wavefront account information has been restored from disk.", clusterUri, accountInfo);
        }
        catch (Exception ex) {
            return this.accountManagementFailure(String.format("Failed to retrieve existing account information from %s.", clusterUri), ex.getMessage());
        }
    }

    private Supplier<String> configureNewAccount(ConfigurableEnvironment environment, String clusterUri, Resource localApiTokenResource) {
        try {
            AccountInfo accountInfo = this.invokeAccountManagementClient(environment, (client, applicationInfo) -> this.provisionAccount((AccountManagementClient)client, clusterUri, (ApplicationTags)applicationInfo));
            this.registerApiToken(environment, accountInfo.apiToken());
            this.writeApiTokenToDisk(localApiTokenResource, accountInfo.apiToken());
            return this.accountManagementSuccess("A Wavefront account has been provisioned successfully and the API token has been saved to disk.", clusterUri, accountInfo);
        }
        catch (Exception ex) {
            return this.accountManagementFailure(String.format("Failed to auto-negotiate a Wavefront api token from %s.", clusterUri), ex.getMessage());
        }
    }

    private Supplier<String> accountManagementSuccess(String message, String clusterUri, AccountInfo accountInfo) {
        StringBuilder sb = new StringBuilder(String.format("%n%s%n%n", message));
        sb.append(String.format("To share this account, make sure the following is added to your configuration:%n%n", new Object[0]));
        sb.append(String.format("\t%s=%s%n", API_TOKEN_PROPERTY, accountInfo.apiToken()));
        sb.append(String.format("\t%s=%s%n%n", URI_PROPERTY, clusterUri));
        sb.append(String.format("Connect to your Wavefront dashboard using this one-time use link:%n%s%n", accountInfo.loginUrl()));
        return sb::toString;
    }

    private Supplier<String> accountManagementFailure(String reason, String message) {
        StringBuilder sb = new StringBuilder(String.format("%n%s", reason));
        if (StringUtils.hasText((String)message)) {
            sb.append(String.format(" The error was:%n%n%s%n%n", message));
        }
        return sb::toString;
    }

    private String readExistingApiToken(Resource localApiTokenResource) {
        if (localApiTokenResource.isReadable()) {
            String string;
            block9: {
                InputStream in = localApiTokenResource.getInputStream();
                try {
                    string = StreamUtils.copyToString((InputStream)in, (Charset)StandardCharsets.UTF_8).trim();
                    if (in == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        this.logger.error((Object)("Failed to read wavefront token from " + localApiTokenResource), (Throwable)ex);
                    }
                }
                in.close();
            }
            return string;
        }
        return null;
    }

    private void writeApiTokenToDisk(Resource localApiTokenResource, String apiToken) {
        if (localApiTokenResource.isFile()) {
            try (FileOutputStream out = new FileOutputStream(localApiTokenResource.getFile());){
                StreamUtils.copy((String)apiToken, (Charset)StandardCharsets.UTF_8, (OutputStream)out);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private AccountInfo invokeAccountManagementClient(ConfigurableEnvironment environment, BiFunction<AccountManagementClient, ApplicationTags, AccountInfo> accountProvider) {
        RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        AccountManagementClient client = new AccountManagementClient(restTemplateBuilder, Utils.getVersion((String)"wavefront-spring-boot").orElse(null));
        ApplicationTags applicationTags = new ApplicationTagsFactory().createFromEnvironment((Environment)environment);
        return accountProvider.apply(client, applicationTags);
    }

    private void registerApiToken(ConfigurableEnvironment environment, String apiToken) {
        HashMap<String, Object> wavefrontSettings = new HashMap<String, Object>();
        wavefrontSettings.put(FREEMIUM_ACCOUNT_PROPERTY, true);
        wavefrontSettings.put(API_TOKEN_PROPERTY, apiToken);
        String configuredClusterUri = environment.getProperty(URI_PROPERTY);
        if (!StringUtils.hasText((String)configuredClusterUri)) {
            wavefrontSettings.put(URI_PROPERTY, DEFAULT_CLUSTER_URI);
        }
        MapPropertySource wavefrontPropertySource = new MapPropertySource("wavefront", wavefrontSettings);
        environment.getPropertySources().addLast((PropertySource)wavefrontPropertySource);
    }

    protected boolean shouldEnableAccountManagement(Thread thread) {
        return AccountManagementEnablementDeducer.shouldEnable(thread);
    }

    protected Resource getLocalApiTokenResource() {
        return new PathResource(Paths.get(System.getProperty("user.home"), ".wavefront_freemium"));
    }

    protected AccountInfo getExistingAccount(AccountManagementClient client, String clusterUri, ApplicationTags applicationTags, String apiToken) {
        this.logger.debug((Object)("Retrieving existing account from " + clusterUri));
        return client.getExistingAccount(clusterUri, applicationTags, apiToken);
    }

    protected AccountInfo provisionAccount(AccountManagementClient client, String clusterUri, ApplicationTags applicationTags) {
        this.logger.debug((Object)("Auto-negotiating Wavefront user account from " + clusterUri));
        return client.provisionAccount(clusterUri, applicationTags);
    }
}

