/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.spring.account;

import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.spring.account.AccountInfo;
import com.wavefront.spring.account.AccountManagementFailedException;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import org.springframework.boot.json.BasicJsonParser;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class AccountManagementClient {
    private final RestTemplate restTemplate;
    private final String version;

    public AccountManagementClient(RestTemplateBuilder restTemplateBuilder, String version) {
        this.restTemplate = restTemplateBuilder.setConnectTimeout(Duration.ofSeconds(10L)).setReadTimeout(Duration.ofSeconds(10L)).build();
        this.version = version;
    }

    public AccountInfo provisionAccount(String clusterUri, ApplicationTags applicationTags) {
        URI requestUri = this.accountManagementUri(clusterUri, applicationTags);
        try {
            String json = (String)this.restTemplate.postForObject(requestUri, null, String.class);
            Map content = new BasicJsonParser().parseMap(json);
            return new AccountInfo((String)content.get("token"), this.determineLoginUrl(clusterUri, (String)content.get("url")));
        }
        catch (HttpClientErrorException ex) {
            throw new AccountManagementFailedException(ex.getResponseBodyAsString());
        }
    }

    public AccountInfo getExistingAccount(String clusterUri, ApplicationTags applicationTags, String apiToken) {
        URI requestUri = this.accountManagementUri(clusterUri, applicationTags);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + apiToken);
        try {
            String json = (String)this.restTemplate.exchange(requestUri, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class).getBody();
            Map content = new BasicJsonParser().parseMap(json);
            return new AccountInfo(apiToken, this.determineLoginUrl(clusterUri, (String)content.get("url")));
        }
        catch (HttpClientErrorException ex) {
            throw new AccountManagementFailedException(ex.getResponseBodyAsString());
        }
    }

    private URI accountManagementUri(String clusterUri, ApplicationTags applicationTags) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)clusterUri).path("/api/v2/trial/spring-boot-autoconfigure").queryParam("application", new Object[]{applicationTags.getApplication()}).queryParam("service", new Object[]{applicationTags.getService()});
        if (applicationTags.getCluster() != null) {
            uriComponentsBuilder.queryParam("cluster", new Object[]{applicationTags.getCluster()});
        }
        if (applicationTags.getShard() != null) {
            uriComponentsBuilder.queryParam("shard", new Object[]{applicationTags.getShard()});
        }
        if (this.version != null) {
            uriComponentsBuilder.queryParam("starterVersion", new Object[]{this.version});
        }
        return uriComponentsBuilder.build().toUri();
    }

    private String determineLoginUrl(String clusterUri, String loginUri) {
        return UriComponentsBuilder.fromUriString((String)clusterUri).path(loginUri).build().toUriString();
    }
}

