/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.spring.autoconfigure;

import brave.Tracer;
import brave.TracingCustomizer;
import brave.handler.SpanHandler;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.spring.autoconfigure.WavefrontProperties;
import com.wavefront.spring.autoconfigure.WavefrontSleuthBraveSpanHandler;
import com.wavefront.spring.autoconfigure.WavefrontSleuthSpanHandler;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.wavefront.WavefrontConfig;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SpanNamer.class, MeterRegistry.class, WavefrontConfig.class, WavefrontSender.class})
@AutoConfigureBefore(value={BraveAutoConfiguration.class})
class WavefrontTracingSleuthConfiguration {
    static final String BEAN_NAME = "wavefrontTracingCustomizer";

    WavefrontTracingSleuthConfiguration() {
    }

    @Bean
    @ConditionalOnBean(value={MeterRegistry.class, WavefrontConfig.class, WavefrontSender.class})
    WavefrontSleuthSpanHandler wavefrontSleuthSpanHandler(MeterRegistry meterRegistry, WavefrontSender wavefrontSender, ApplicationTags applicationTags, WavefrontConfig wavefrontConfig, WavefrontProperties wavefrontProperties) {
        return new WavefrontSleuthSpanHandler(50000, wavefrontSender, meterRegistry, wavefrontConfig.source(), applicationTags, wavefrontProperties);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Tracer.class, TracingCustomizer.class, SpanHandler.class})
    static class BraveCustomizerConfiguration {
        BraveCustomizerConfiguration() {
        }

        @Bean(value={"wavefrontTracingCustomizer"})
        @ConditionalOnMissingBean(name={"wavefrontTracingCustomizer"})
        @ConditionalOnBean(value={MeterRegistry.class, WavefrontConfig.class, WavefrontSender.class})
        TracingCustomizer wavefrontTracingCustomizer(WavefrontSleuthSpanHandler spanHandler) {
            return t -> t.traceId128Bit(true).supportsJoin(false).addSpanHandler((SpanHandler)new WavefrontSleuthBraveSpanHandler(spanHandler));
        }
    }
}

