/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.spring.autoconfigure;

import com.wavefront.opentracing.WavefrontTracer;
import com.wavefront.opentracing.reporting.CompositeReporter;
import com.wavefront.opentracing.reporting.Reporter;
import com.wavefront.opentracing.reporting.WavefrontSpanReporter;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.sdk.entities.tracing.sampling.DurationSampler;
import com.wavefront.sdk.entities.tracing.sampling.RateSampler;
import com.wavefront.sdk.entities.tracing.sampling.Sampler;
import com.wavefront.spring.autoconfigure.WavefrontProperties;
import com.wavefront.spring.autoconfigure.WavefrontTracerBuilderCustomizer;
import io.micrometer.wavefront.WavefrontConfig;
import io.opentracing.Tracer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Reporter.class, Tracer.class})
@ConditionalOnBean(value={WavefrontSender.class})
@ConditionalOnMissingBean(name={"wavefrontTracingCustomizer"})
class WavefrontTracingOpenTracingConfiguration {
    WavefrontTracingOpenTracingConfiguration() {
    }

    @Bean(destroyMethod="flush")
    @ConditionalOnMissingBean(value={Tracer.class})
    WavefrontTracer wavefrontTracer(ApplicationTags applicationTags, WavefrontProperties wavefrontProperties, ObjectProvider<Reporter> reporters, ObjectProvider<WavefrontTracerBuilderCustomizer> customizers) {
        Reporter compositeReporter = this.createCompositeReporter(reporters.orderedStream());
        WavefrontTracer.Builder builder = new WavefrontTracer.Builder(compositeReporter, applicationTags).excludeJvmMetrics();
        builder.redMetricsCustomTagKeys(new HashSet<String>(wavefrontProperties.getTracing().getRedMetricsCustomTagKeys()));
        List<Sampler> samplers = this.createSamplers(wavefrontProperties.getTracing().getOpentracing().getSampler());
        samplers.forEach(arg_0 -> ((WavefrontTracer.Builder)builder).withSampler(arg_0));
        customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean(value={Reporter.class})
    Reporter wavefrontSpanReporter(WavefrontSender wavefrontSender, WavefrontConfig wavefrontConfig) {
        return new WavefrontSpanReporter.Builder().withSource(wavefrontConfig.source()).build(wavefrontSender);
    }

    private Reporter createCompositeReporter(Stream<Reporter> reporters) {
        Reporter[] reporterArray = (Reporter[])reporters.toArray(Reporter[]::new);
        return reporterArray.length > 1 ? new CompositeReporter(reporterArray) : reporterArray[0];
    }

    private List<Sampler> createSamplers(WavefrontProperties.Tracing.Opentracing.Sampler samplerProperties) {
        ArrayList<Sampler> samplers = new ArrayList<Sampler>();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from((Object)samplerProperties.getProbability()).to(probability -> samplers.add((Sampler)new RateSampler(probability.doubleValue())));
        map.from((Object)samplerProperties.getDuration()).to(duration -> samplers.add((Sampler)new DurationSampler(duration.toMillis())));
        return samplers;
    }
}

