/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.spring.autoconfigure;

import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.spring.autoconfigure.ApplicationTagsBuilderCustomizer;
import com.wavefront.spring.autoconfigure.WavefrontProperties;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class ApplicationTagsFactory {
    private static final String PREFIX = "wavefront.application.";
    private final List<ApplicationTagsBuilderCustomizer> customizers;

    public ApplicationTagsFactory(List<ApplicationTagsBuilderCustomizer> customizers) {
        this.customizers = customizers != null ? customizers : Collections.emptyList();
    }

    public ApplicationTagsFactory() {
        this(null);
    }

    public ApplicationTags createFromProperties(Environment environment, WavefrontProperties properties) {
        WavefrontProperties.Application application = properties.getApplication();
        String service = StringUtils.hasText((String)application.getService()) ? application.getService() : this.defaultServiceName(environment);
        ApplicationTags.Builder builder = new ApplicationTags.Builder(application.getName(), service);
        PropertyMapper mapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        mapper.from(application::getCluster).to(arg_0 -> ((ApplicationTags.Builder)builder).cluster(arg_0));
        mapper.from(application::getShard).to(arg_0 -> ((ApplicationTags.Builder)builder).shard(arg_0));
        return this.customize(builder).build();
    }

    public ApplicationTags createFromEnvironment(Environment environment) {
        String name = this.getValue(environment, "name", () -> "unnamed_application");
        String service = this.getValue(environment, "service", () -> this.defaultServiceName(environment));
        return this.customize(new ApplicationTags.Builder(name, service).cluster(this.getValue(environment, "cluster", () -> null)).shard(this.getValue(environment, "shard", () -> null))).build();
    }

    private String defaultServiceName(Environment environment) {
        String applicationName = environment.getProperty("spring.application.name");
        return StringUtils.hasText((String)applicationName) ? applicationName : WavefrontProperties.Application.DEFAULT_SERVICE_NAME;
    }

    private ApplicationTags.Builder customize(ApplicationTags.Builder builder) {
        this.customizers.forEach(customizer -> customizer.customize(builder));
        return builder;
    }

    private String getValue(Environment environment, String name, Supplier<String> fallback) {
        String value = environment.getProperty(PREFIX + name);
        return value != null ? value : fallback.get();
    }
}

