/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.voice.ncco.Action;
import com.vonage.client.voice.ncco.EventMethod;
import com.vonage.client.voice.ncco.TranscriptionSettings;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;

public class ConversationAction
extends JsonableBaseObject
implements Action {
    private String name;
    private Boolean startOnEnter;
    private Boolean endOnExit;
    private Boolean record;
    private Boolean mute;
    private EventMethod eventMethod;
    private Collection<URI> musicOnHoldUrl;
    private Collection<URI> eventUrl;
    private Collection<String> canSpeak;
    private Collection<String> canHear;
    private TranscriptionSettings transcription;

    ConversationAction() {
    }

    private ConversationAction(Builder builder) {
        this.name = builder.name;
        this.musicOnHoldUrl = builder.musicOnHoldUrl != null ? Collections.singletonList(URI.create(builder.musicOnHoldUrl)) : null;
        this.startOnEnter = builder.startOnEnter;
        this.endOnExit = builder.endOnExit;
        this.mute = builder.mute;
        this.record = builder.record;
        this.eventUrl = builder.eventUrl != null ? Collections.singletonList(URI.create(builder.eventUrl)) : null;
        this.eventMethod = builder.eventMethod;
        this.canSpeak = builder.canSpeak;
        this.canHear = builder.canHear;
        this.transcription = builder.transcription;
        if (!(this.transcription == null || this.record != null && this.record.booleanValue())) {
            throw new IllegalStateException("Recording must be enabled for transcription.");
        }
    }

    @Override
    public String getAction() {
        return "conversation";
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="musicOnHoldUrl")
    public Collection<URI> getMusicOnHoldUrl() {
        return this.musicOnHoldUrl;
    }

    @JsonProperty(value="startOnEnter")
    public Boolean getStartOnEnter() {
        return this.startOnEnter;
    }

    @JsonProperty(value="endOnExit")
    public Boolean getEndOnExit() {
        return this.endOnExit;
    }

    @JsonProperty(value="mute")
    public Boolean getMute() {
        return this.mute;
    }

    @JsonProperty(value="record")
    public Boolean getRecord() {
        return this.record;
    }

    @JsonProperty(value="eventUrl")
    public Collection<URI> getEventUrl() {
        return this.eventUrl;
    }

    @JsonProperty(value="eventMethod")
    public EventMethod getEventMethod() {
        return this.eventMethod;
    }

    @JsonProperty(value="canSpeak")
    public Collection<String> getCanSpeak() {
        return this.canSpeak;
    }

    @JsonProperty(value="canHear")
    public Collection<String> getCanHear() {
        return this.canHear;
    }

    @JsonProperty(value="transcription")
    public TranscriptionSettings getTranscription() {
        return this.transcription;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private String name;
        private String eventUrl;
        private String musicOnHoldUrl;
        private EventMethod eventMethod;
        private Boolean startOnEnter;
        private Boolean endOnExit;
        private Boolean record;
        private Boolean mute;
        private Collection<String> canSpeak;
        private Collection<String> canHear;
        private TranscriptionSettings transcription;

        Builder(String name) {
            this.name = name;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder musicOnHoldUrl(String musicOnHoldUrl) {
            this.musicOnHoldUrl = musicOnHoldUrl;
            return this;
        }

        public Builder startOnEnter(boolean startOnEnter) {
            this.startOnEnter = startOnEnter;
            return this;
        }

        public Builder endOnExit(boolean endOnExit) {
            this.endOnExit = endOnExit;
            return this;
        }

        public Builder record(boolean record) {
            this.record = record;
            return this;
        }

        public Builder eventUrl(String eventUrl) {
            this.eventUrl = eventUrl;
            return this;
        }

        public Builder eventMethod(EventMethod eventMethod) {
            this.eventMethod = eventMethod;
            return this;
        }

        public Builder mute(boolean mute) {
            this.mute = mute;
            return this;
        }

        public Builder addCanSpeak(String ... uuid) {
            if (this.canSpeak == null) {
                this.canSpeak = new LinkedHashSet<String>();
            }
            this.canSpeak.addAll(Arrays.asList(uuid));
            return this;
        }

        public Builder addCanHear(String ... uuid) {
            if (this.canHear == null) {
                this.canHear = new LinkedHashSet<String>(uuid.length);
            }
            this.canHear.addAll(Arrays.asList(uuid));
            return this;
        }

        public Builder canSpeak(Collection<String> canSpeak) {
            this.canSpeak = canSpeak;
            return this;
        }

        public Builder canHear(Collection<String> canHear) {
            this.canHear = canHear;
            return this;
        }

        public Builder transcription(TranscriptionSettings transcription) {
            this.transcription = transcription;
            return this;
        }

        public ConversationAction build() {
            if (this.canSpeak != null) {
                this.canSpeak = this.canSpeak.stream().distinct().collect(Collectors.toList());
            }
            if (this.canHear != null) {
                this.canHear = this.canHear.stream().distinct().collect(Collectors.toList());
            }
            return new ConversationAction(this);
        }
    }
}

