/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.voice.AdvancedMachineDetection;
import com.vonage.client.voice.MachineDetection;
import com.vonage.client.voice.ncco.Action;
import com.vonage.client.voice.ncco.ConnectEndpoint;
import com.vonage.client.voice.ncco.EventMethod;
import com.vonage.client.voice.ncco.EventType;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class ConnectAction
extends JsonableBaseObject
implements Action {
    private Collection<ConnectEndpoint> endpoint;
    private String from;
    private EventType eventType;
    private Integer limit;
    private Integer timeOut;
    private MachineDetection machineDetection;
    private AdvancedMachineDetection advancedMachineDetection;
    private Collection<URI> eventUrl;
    private EventMethod eventMethod;
    private Boolean randomFromNumber;
    private URI ringbackTone;

    ConnectAction() {
    }

    private ConnectAction(Builder builder) {
        this.endpoint = Collections.singleton(Objects.requireNonNull(builder.endpoint, "An endpoint must be specified."));
        this.limit = builder.limit;
        if (this.limit != null && (this.limit < 1 || this.limit > 7200)) {
            throw new IllegalArgumentException("'limit' must be positive and less than 7200 seconds.");
        }
        this.timeOut = builder.timeOut;
        if (this.timeOut != null && (this.timeOut < 3 || this.timeOut > 7200)) {
            throw new IllegalArgumentException("'timeOut' must be between 3 and 7200 seconds.");
        }
        this.from = builder.from;
        this.randomFromNumber = builder.randomFromNumber;
        if (this.randomFromNumber != null && this.from != null) {
            throw new IllegalStateException("'randomFromNumber' and 'from' cannot be used together.");
        }
        this.eventType = builder.eventType;
        this.machineDetection = builder.machineDetection;
        this.advancedMachineDetection = builder.advancedMachineDetection;
        this.eventUrl = builder.eventUrl != null ? Collections.singleton(URI.create(builder.eventUrl)) : null;
        this.eventMethod = builder.eventMethod;
        this.ringbackTone = builder.ringbackTone != null ? URI.create(builder.ringbackTone) : null;
    }

    @Override
    public String getAction() {
        return "connect";
    }

    @JsonProperty(value="endpoint")
    public Collection<ConnectEndpoint> getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonProperty(value="eventType")
    public EventType getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="timeout")
    public Integer getTimeOut() {
        return this.timeOut;
    }

    @JsonProperty(value="limit")
    public Integer getLimit() {
        return this.limit;
    }

    @JsonProperty(value="machineDetection")
    public MachineDetection getMachineDetection() {
        return this.machineDetection;
    }

    @JsonProperty(value="advancedMachineDetection")
    public AdvancedMachineDetection getAdvancedMachineDetection() {
        return this.advancedMachineDetection;
    }

    @JsonProperty(value="eventUrl")
    public Collection<URI> getEventUrl() {
        return this.eventUrl;
    }

    @JsonProperty(value="eventMethod")
    public EventMethod getEventMethod() {
        return this.eventMethod;
    }

    @JsonProperty(value="randomFromNumber")
    public Boolean getRandomFromNumber() {
        return this.randomFromNumber;
    }

    @JsonProperty(value="ringbackTone")
    public URI getRingbackTone() {
        return this.ringbackTone;
    }

    public static Builder builder(ConnectEndpoint endpoint) {
        return ConnectAction.builder().endpoint(endpoint);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ConnectEndpoint endpoint;
        private String from;
        private String eventUrl;
        private String ringbackTone;
        private EventType eventType;
        private Integer timeOut;
        private Integer limit;
        private MachineDetection machineDetection;
        private AdvancedMachineDetection advancedMachineDetection;
        private EventMethod eventMethod;
        private Boolean randomFromNumber;

        Builder() {
        }

        public Builder endpoint(ConnectEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder eventType(EventType eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder timeOut(int timeOut) {
            this.timeOut = timeOut;
            return this;
        }

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder machineDetection(MachineDetection machineDetection) {
            this.machineDetection = machineDetection;
            return this;
        }

        public Builder advancedMachineDetection(AdvancedMachineDetection advancedMachineDetection) {
            this.advancedMachineDetection = advancedMachineDetection;
            return this;
        }

        public Builder eventUrl(String eventUrl) {
            this.eventUrl = eventUrl;
            return this;
        }

        public Builder eventMethod(EventMethod eventMethod) {
            this.eventMethod = eventMethod;
            return this;
        }

        public Builder randomFromNumber(boolean randomFromNumber) {
            this.randomFromNumber = randomFromNumber;
            return this;
        }

        public Builder ringbackTone(String ringbackTone) {
            this.ringbackTone = ringbackTone;
            return this;
        }

        public ConnectAction build() {
            return new ConnectAction(this);
        }
    }
}

