/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.users.channels.Websocket;
import com.vonage.client.voice.CallEndpoint;
import com.vonage.client.voice.EndpointType;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

public class WebSocketEndpoint
extends JsonableBaseObject
implements CallEndpoint {
    private URI uri;
    private Websocket.ContentType contentType;
    @JsonProperty(value="headers")
    private Map<String, Object> headers;

    protected WebSocketEndpoint() {
    }

    public WebSocketEndpoint(String uri, String contentType, Map<String, Object> headers) {
        this(URI.create(uri), contentType != null ? Websocket.ContentType.fromString(contentType) : null, headers);
    }

    public WebSocketEndpoint(URI uri, Websocket.ContentType contentType, Map<String, Object> headers) {
        this.uri = Objects.requireNonNull(uri, "URI is required.");
        this.contentType = contentType;
        this.headers = headers;
    }

    @Override
    public EndpointType getType() {
        return EndpointType.WEBSOCKET;
    }

    @Override
    public String toLog() {
        return "uri=" + this.uri + " content-type=" + (Object)((Object)this.contentType);
    }

    @JsonProperty(value="uri")
    public URI getUri() {
        return this.uri;
    }

    @JsonProperty(value="content-type")
    public Websocket.ContentType getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="headers")
    public Map<String, Object> getHeadersMap() {
        return this.headers;
    }
}

