/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum TextToSpeechLanguage {
    AFRIKAANS("af-ZA"),
    ARABIC("ar"),
    BULGARIAN("bg-BG"),
    BENGALI("bn-IN"),
    SPANISH_CATALAN("ca-ES"),
    CHINESE_MANDARIN("cmn-CN"),
    TAIWANESE_MANDARIN("cmn-TW"),
    CZECH("cs-CZ"),
    WELSH("cy-GB"),
    DANISH("da-DK"),
    AUSTRIAN_GERMAN("de-AT"),
    GERMAN("de-DE"),
    GREEK("el-GR"),
    AUSTRALIAN_ENGLISH("en-AU"),
    UNITED_KINGDOM_ENGLISH("en-GB"),
    SCOTTISH_ENGLISH("en-GB-SCT"),
    WELSH_ENGLISH("en-GB-WLS"),
    IRISH_ENGLISH("en-IE"),
    INDIAN_ENGLISH("en-IN"),
    NEW_ZEALAND_ENGLISH("en-NZ"),
    AMERICAN_ENGLISH("en-US"),
    SOUTH_AFRICAN_ENGLISH("en-ZA"),
    COLOMBIAN_SPANISH("es-CO"),
    SPANISH("es-ES"),
    MEXICAN_SPANISH("es-MX"),
    AMERICAN_SPANISH("es-US"),
    BASQUE("eu-ES"),
    FINISH("fi-FI"),
    FILIPINO("fil-PH"),
    CANADIAN_FRENCH("fr-CA"),
    FRENCH("fr-FR"),
    SPANISH_GALICIAN("gl-ES"),
    GUJARATI("gu-IN"),
    HEBREW("he-IL"),
    HINDI("hi-IN"),
    HUNGARIAN("hu-HU"),
    INDONESIAN("id-ID"),
    ICELANDIC("is-IS"),
    ITALIAN("it-IT"),
    JAPANESE("ja-JP"),
    KANNADA("kn-IN"),
    KOREAN("ko-KR"),
    LATVIAN("lv-LV"),
    MALAYALAM("ml-IN"),
    MALAY("ms-MY"),
    NORWEGIAN("no-NO"),
    NORWEGIAN_BOKMAL("nb-NO"),
    BELGIAN_DUTCH("nl-BE"),
    DUTCH("nl-NL"),
    PUNJABI("pa-IN"),
    POLISH("pl-PL"),
    BRAZILIAN_PORTUGUESE("pt-BR"),
    PORTUGUESE("pt-PT"),
    ROMANIAN("ro-RO"),
    RUSSIAN("ru-RU"),
    SLOVAK("sk-SK"),
    SERBIAN("sr-RS"),
    SWEDISH("sv-SE"),
    TAMIL("ta-IN"),
    TELUGU("te-IN"),
    THAI("th-TH"),
    TURKISH("tr-TR"),
    UKRAINIAN("uk-UA"),
    VIETNAMESE("vi-VN"),
    CHINESE_YUE("yue-CN"),
    UNKNOWN("Unknown");

    private final String language;

    private TextToSpeechLanguage(String language) {
        this.language = language;
    }

    @JsonValue
    public String getLanguage() {
        return this.language;
    }

    public String toString() {
        return this.getLanguage();
    }

    @JsonCreator
    public static TextToSpeechLanguage fromString(String language) {
        if (language == null || language.trim().isEmpty()) {
            return null;
        }
        for (TextToSpeechLanguage ttsLanguage : TextToSpeechLanguage.values()) {
            if (!ttsLanguage.getLanguage().equals(language)) continue;
            return ttsLanguage;
        }
        return UNKNOWN;
    }
}

