/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.voice.UuidRequestWrapper;
import java.net.URI;
import java.util.Objects;

public final class StreamPayload
extends UuidRequestWrapper {
    private final URI[] streamUrl;
    private final Integer loop;
    private final Double level;

    StreamPayload(Builder builder) {
        this.streamUrl = new URI[]{Objects.requireNonNull(builder.streamUrl, "Stream URL is required.")};
        this.loop = builder.loop;
        this.level = builder.level;
    }

    @JsonProperty(value="stream_url")
    public URI[] getStreamUrl() {
        return this.streamUrl;
    }

    @JsonProperty(value="loop")
    public Integer getLoop() {
        return this.loop;
    }

    @JsonProperty(value="level")
    public Double getLevel() {
        return this.level;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private URI streamUrl;
        private Integer loop;
        private Double level;

        Builder() {
        }

        public Builder streamUrl(String streamUrl) {
            return this.streamUrl(URI.create(streamUrl));
        }

        public Builder streamUrl(URI streamUrl) {
            this.streamUrl = streamUrl;
            return this;
        }

        public Builder loop(int loop) {
            this.loop = loop;
            return this;
        }

        public Builder level(double level) {
            this.level = level;
            return this;
        }

        public StreamPayload build() {
            return new StreamPayload(this);
        }
    }
}

