/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify2;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.auth.ApiKeyHeaderAuthMethod;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.common.HttpMethod;
import com.vonage.client.verify2.ListTemplateFragmentsResponse;
import com.vonage.client.verify2.ListTemplatesRequest;
import com.vonage.client.verify2.ListTemplatesResponse;
import com.vonage.client.verify2.Template;
import com.vonage.client.verify2.TemplateFragment;
import com.vonage.client.verify2.TemplateFragmentRequestWrapper;
import com.vonage.client.verify2.VerificationRequest;
import com.vonage.client.verify2.VerificationResponse;
import com.vonage.client.verify2.VerifyCodeRequestWrapper;
import com.vonage.client.verify2.VerifyCodeResponse;
import com.vonage.client.verify2.VerifyResponseException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;

public class Verify2Client {
    final boolean hasJwtAuthMethod;
    final RestEndpoint<VerificationRequest, VerificationResponse> verifyUser;
    final RestEndpoint<VerifyCodeRequestWrapper, VerifyCodeResponse> verifyRequest;
    final RestEndpoint<UUID, Void> cancel;
    final RestEndpoint<UUID, Void> nextWorkflow;
    final RestEndpoint<UUID, Void> deleteTemplate;
    final RestEndpoint<ListTemplatesRequest, ListTemplatesResponse> listTemplates;
    final RestEndpoint<UUID, Template> getTemplate;
    final RestEndpoint<Template, Template> createTemplate;
    final RestEndpoint<Template, Template> updateTemplate;
    final RestEndpoint<ListTemplatesRequest, ListTemplateFragmentsResponse> listFragments;
    final RestEndpoint<TemplateFragmentRequestWrapper, TemplateFragment> getFragment;
    final RestEndpoint<TemplateFragmentRequestWrapper, Void> deleteFragment;
    final RestEndpoint<TemplateFragment, TemplateFragment> createFragment;
    final RestEndpoint<TemplateFragment, TemplateFragment> updateFragment;

    public Verify2Client(final HttpWrapper wrapper) {
        this.hasJwtAuthMethod = wrapper.getAuthCollection().hasAuthMethod(JWTAuthMethod.class);
        final class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            Endpoint(Function<T, String> pathGetter, HttpMethod method, R ... type) {
                super(DynamicEndpoint.builder(type).responseExceptionType(VerifyResponseException.class).wrapper(var5_5).requestMethod(method).authMethod(JWTAuthMethod.class, ApiKeyHeaderAuthMethod.class).pathGetter((de, req) -> {
                    String base = de.getHttpWrapper().getHttpConfig().getApiBaseUri() + "/v2/verify";
                    return pathGetter != null ? base + "/" + (String)pathGetter.apply(req) : base;
                }));
            }
        }
        this.verifyUser = new Endpoint(null, HttpMethod.POST, (Object[])new VerificationResponse[0]);
        this.verifyRequest = new Endpoint(req -> req.requestId, HttpMethod.POST, (Object[])new VerifyCodeResponse[0]);
        this.cancel = new Endpoint(UUID::toString, HttpMethod.DELETE, (Object[])new Void[0]);
        this.nextWorkflow = new Endpoint(id -> id + "/next-workflow", HttpMethod.POST, (Object[])new Void[0]);
        String templatesBase = "templates";
        this.listTemplates = new Endpoint(__ -> "templates", HttpMethod.GET, (Object[])new ListTemplatesResponse[0]);
        this.getTemplate = new Endpoint(id -> "templates/" + id, HttpMethod.GET, (Object[])new Template[0]);
        this.createTemplate = new Endpoint(__ -> "templates", HttpMethod.POST, (Object[])new Template[0]);
        this.updateTemplate = new Endpoint(req -> "templates/" + req.id, HttpMethod.PATCH, (Object[])new Template[0]);
        this.deleteTemplate = new Endpoint(id -> "templates/" + id, HttpMethod.DELETE, (Object[])new Void[0]);
        String fragmentsBase = "/template_fragments";
        this.listFragments = new Endpoint(req -> "templates/" + req.templateId + "/template_fragments", HttpMethod.GET, (Object[])new ListTemplateFragmentsResponse[0]);
        this.getFragment = new Endpoint(req -> "templates/" + req.templateId + "/template_fragments" + '/' + req.fragmentId, HttpMethod.GET, (Object[])new TemplateFragment[0]);
        this.createFragment = new Endpoint(req -> "templates/" + req.templateId + "/template_fragments", HttpMethod.POST, (Object[])new TemplateFragment[0]);
        this.updateFragment = new Endpoint(req -> "templates/" + req.getTemplateId() + "/template_fragments" + '/' + req.fragmentId, HttpMethod.PATCH, (Object[])new TemplateFragment[0]);
        this.deleteFragment = new Endpoint(req -> "templates/" + req.templateId + "/template_fragments" + '/' + req.fragmentId, HttpMethod.DELETE, (Object[])new Void[0]);
    }

    private UUID validateId(String name, UUID id) {
        return Objects.requireNonNull(id, name + " ID is required.");
    }

    private UUID validateRequestId(UUID requestId) {
        return this.validateId("Request", requestId);
    }

    private UUID validateTemplateId(UUID templateId) {
        return this.validateId("Template", templateId);
    }

    private UUID validateFragmentId(UUID fragmentId) {
        return this.validateId("Fragment", fragmentId);
    }

    public VerificationResponse sendVerification(VerificationRequest request) {
        if (request.isCodeless() && !this.hasJwtAuthMethod) {
            throw new IllegalStateException("Codeless verification requires an application ID to be set in order to use webhooks.");
        }
        return this.verifyUser.execute(Objects.requireNonNull(request));
    }

    public VerifyCodeResponse checkVerificationCode(UUID requestId, String code) {
        return this.verifyRequest.execute(new VerifyCodeRequestWrapper(this.validateRequestId(requestId).toString(), Objects.requireNonNull(code, "Code is required.")));
    }

    public boolean isValidVerificationCode(UUID requestId, String code) {
        try {
            this.checkVerificationCode(requestId, code);
            return true;
        }
        catch (VerifyResponseException ex) {
            switch (ex.getStatusCode()) {
                case 400: 
                case 410: {
                    return false;
                }
            }
            throw ex;
        }
    }

    public void cancelVerification(UUID requestId) {
        this.cancel.execute(this.validateRequestId(requestId));
    }

    public void nextWorkflow(UUID requestId) {
        this.nextWorkflow.execute(this.validateRequestId(requestId));
    }

    public Template createTemplate(String name) {
        return this.createTemplate.execute(new Template(Objects.requireNonNull(name, "Name is required."), null, null));
    }

    public List<Template> listTemplates() {
        return this.listTemplates(1, 100).getTemplates();
    }

    ListTemplatesResponse listTemplates(Integer page, Integer pageSize) {
        return this.listTemplates.execute(new ListTemplatesRequest(page, pageSize, null));
    }

    public Template getTemplate(UUID templateId) {
        return this.getTemplate.execute(this.validateTemplateId(templateId));
    }

    public Template updateTemplate(UUID templateId, String name, Boolean isDefault) {
        return this.updateTemplate.execute(new Template(name, isDefault, this.validateTemplateId(templateId)));
    }

    public void deleteTemplate(UUID templateId) {
        this.deleteTemplate.execute(this.validateTemplateId(templateId));
    }

    public TemplateFragment createTemplateFragment(UUID templateId, TemplateFragment fragment) {
        Objects.requireNonNull(fragment, (String)"Template fragment is required.").templateId = this.validateTemplateId(templateId);
        return this.createFragment.execute(fragment);
    }

    public List<TemplateFragment> listTemplateFragments(UUID templateId) {
        return this.listTemplateFragments(templateId, 1, 1000).getTemplateFragments();
    }

    ListTemplateFragmentsResponse listTemplateFragments(UUID templateId, Integer page, Integer pageSize) {
        return this.listFragments.execute(new ListTemplatesRequest(page, pageSize, this.validateTemplateId(templateId)));
    }

    public TemplateFragment getTemplateFragment(UUID templateId, UUID fragmentId) {
        return this.getFragment.execute(new TemplateFragmentRequestWrapper(this.validateTemplateId(templateId), this.validateFragmentId(fragmentId)));
    }

    public TemplateFragment updateTemplateFragment(UUID templateId, UUID fragmentId, String text) {
        return this.updateFragment.execute(new TemplateFragment(text, this.validateTemplateId(templateId), this.validateFragmentId(fragmentId)));
    }

    public void deleteTemplateFragment(UUID templateId, UUID fragmentId) {
        this.deleteFragment.execute(new TemplateFragmentRequestWrapper(this.validateTemplateId(templateId), this.validateFragmentId(fragmentId)));
    }
}

