/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.users;

import com.vonage.client.AbstractQueryParamsRequest;
import com.vonage.client.common.SortOrder;
import java.net.URI;
import java.util.Map;

public final class ListUsersRequest
extends AbstractQueryParamsRequest {
    private final int pageSize;
    private final SortOrder order;
    private final String name;
    private final String cursor;

    private ListUsersRequest(Builder builder) {
        this.pageSize = builder.pageSize;
        if (this.pageSize < 1 || this.pageSize > 100) {
            throw new IllegalArgumentException("Page size must be between 1 and 100.");
        }
        this.order = builder.order;
        this.name = builder.name;
        this.cursor = ListUsersRequest.parseCursor(builder.cursor);
    }

    static String parseCursor(URI cursor) {
        if (cursor == null) {
            return null;
        }
        String query = cursor.getRawQuery();
        return query.substring(query.indexOf("cursor=") + 7);
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        this.conditionalAdd("page_size", this.pageSize);
        this.conditionalAdd("order", (Object)this.order);
        this.conditionalAdd("name", this.name);
        this.conditionalAdd("cursor", this.cursor);
        return params;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public SortOrder getOrder() {
        return this.order;
    }

    public String getName() {
        return this.name;
    }

    public String getCursor() {
        return this.cursor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int pageSize = 10;
        private SortOrder order = SortOrder.ASCENDING;
        private String name;
        private URI cursor;

        Builder() {
        }

        public Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder order(SortOrder order) {
            this.order = order;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder cursor(URI cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListUsersRequest build() {
            return new ListUsersRequest(this);
        }
    }
}

