/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.whatsapp;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.common.MessageType;
import com.vonage.client.messages.CaptionMediaMessageRequest;
import com.vonage.client.messages.internal.MessagePayload;
import com.vonage.client.messages.whatsapp.WhatsappRequest;

public final class WhatsappImageRequest
extends WhatsappRequest
implements CaptionMediaMessageRequest {
    WhatsappImageRequest(Builder builder) {
        super(builder, MessageType.IMAGE);
        this.media.validateUrlExtension("jpg", "jpeg", "png");
        this.media.validateCaptionLength(3000);
    }

    @JsonProperty(value="image")
    public MessagePayload getImage() {
        return this.media;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WhatsappRequest.Builder<WhatsappImageRequest, Builder>
    implements CaptionMediaMessageRequest.Builder<Builder> {
        Builder() {
        }

        @Override
        public Builder url(String url) {
            return (Builder)super.url(url);
        }

        @Override
        public Builder caption(String caption) {
            return (Builder)super.caption(caption);
        }

        @Override
        public WhatsappImageRequest build() {
            return new WhatsappImageRequest(this);
        }
    }
}

