/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.sms;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.common.MessageType;
import com.vonage.client.messages.Channel;
import com.vonage.client.messages.MessageRequest;
import com.vonage.client.messages.TextMessageRequest;
import com.vonage.client.messages.sms.EncodingType;
import com.vonage.client.messages.sms.OutboundSettings;

public final class SmsTextRequest
extends MessageRequest
implements TextMessageRequest {
    final OutboundSettings sms;

    SmsTextRequest(Builder builder) {
        super(builder, Channel.SMS, MessageType.TEXT);
        this.sms = OutboundSettings.construct(builder.encodingType, builder.contentId, builder.entityId);
    }

    @Override
    public String getText() {
        return super.getText();
    }

    @JsonProperty(value="sms")
    public OutboundSettings getMessageSettings() {
        return this.sms;
    }

    @Override
    @JsonProperty(value="ttl")
    public Integer getTtl() {
        return this.ttl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends MessageRequest.Builder<SmsTextRequest, Builder>
    implements TextMessageRequest.Builder<Builder> {
        String contentId;
        String entityId;
        EncodingType encodingType;

        Builder() {
        }

        @Override
        public Builder text(String text) {
            return (Builder)super.text(text);
        }

        public Builder encodingType(EncodingType encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        public Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        @Override
        public Builder ttl(int ttl) {
            return (Builder)super.ttl(ttl);
        }

        @Override
        public SmsTextRequest build() {
            return new SmsTextRequest(this);
        }
    }
}

