/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.mms;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.common.MessageType;
import com.vonage.client.messages.internal.MessagePayload;
import java.net.URI;
import java.util.Objects;

public class Content
extends JsonableBaseObject {
    private MessageType type;
    private URI url;
    private String caption;

    protected Content() {
    }

    public Content(MessageType type, String url, String caption) {
        this.type = Objects.requireNonNull(type, "Media type is required.");
        switch (this.type) {
            case AUDIO: 
            case VIDEO: 
            case FILE: 
            case IMAGE: 
            case VCARD: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported media type: " + (Object)((Object)type));
            }
        }
        MessagePayload payload = new MessagePayload(url, caption);
        payload.validateCaptionLength(2000);
        this.url = payload.getUrl();
        this.caption = payload.getCaption();
    }

    public Content(MessageType type, String url) {
        this(type, url, null);
    }

    @JsonProperty(value="type")
    public MessageType getType() {
        return this.type;
    }

    @JsonProperty(value="url")
    public URI getUrl() {
        return this.url;
    }

    @JsonProperty(value="caption")
    public String getCaption() {
        return this.caption;
    }
}

