/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.vonage.client.common.MessageType;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;

public enum Channel {
    SMS(MessageType.TEXT, new MessageType[0]),
    MMS(MessageType.TEXT, MessageType.IMAGE, MessageType.VCARD, MessageType.AUDIO, MessageType.VIDEO, MessageType.FILE, MessageType.CONTENT),
    RCS(MessageType.TEXT, MessageType.IMAGE, MessageType.VIDEO, MessageType.FILE, MessageType.CUSTOM, MessageType.AUDIO, MessageType.LOCATION, MessageType.VCARD, MessageType.REPLY, MessageType.BUTTON),
    WHATSAPP(MessageType.TEXT, MessageType.IMAGE, MessageType.AUDIO, MessageType.VIDEO, MessageType.FILE, MessageType.TEMPLATE, MessageType.CUSTOM, MessageType.LOCATION, MessageType.STICKER, MessageType.ORDER, MessageType.REPLY, MessageType.REACTION, MessageType.CONTACT, MessageType.BUTTON, MessageType.UNSUPPORTED),
    MESSENGER(MessageType.TEXT, MessageType.IMAGE, MessageType.AUDIO, MessageType.VIDEO, MessageType.FILE, MessageType.UNSUPPORTED),
    VIBER(MessageType.TEXT, MessageType.IMAGE, MessageType.VIDEO, MessageType.FILE);

    private final Set<MessageType> supportedTypes;

    private Channel(MessageType type1, MessageType ... additionalTypes) {
        this.supportedTypes = EnumSet.of(type1, additionalTypes);
    }

    public Set<MessageType> getSupportedMessageTypes() {
        return this.supportedTypes;
    }

    public Set<MessageType> getSupportedOutboundMessageTypes() {
        return this.getSupportedMessageTypes().stream().filter(mt -> mt != MessageType.UNSUPPORTED && mt != MessageType.REPLY && mt != MessageType.ORDER && mt != MessageType.CONTACT && mt != MessageType.BUTTON && (this != RCS || mt != MessageType.AUDIO && mt != MessageType.LOCATION && mt != MessageType.VCARD)).collect(Collectors.toSet());
    }

    @JsonCreator
    public static Channel fromString(String value) {
        if (value == null) {
            return null;
        }
        String upper = value.toUpperCase();
        return upper.equals("VIBER_SERVICE") ? VIBER : Channel.valueOf(upper);
    }

    @JsonValue
    public String toString() {
        if (this == VIBER) {
            return "viber_service";
        }
        return this.name().toLowerCase();
    }
}

