/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.insight;

import com.vonage.client.insight.BaseInsightRequest;
import java.net.URI;
import java.util.Map;

public final class AdvancedInsightAsyncRequest
extends BaseInsightRequest {
    private final URI callback;

    AdvancedInsightAsyncRequest(Builder builder) {
        super(builder.number, builder.country);
        this.cnam = builder.cnam;
        if (builder.callback == null || builder.callback.trim().isEmpty()) {
            throw new IllegalArgumentException("Callback URL is required.");
        }
        this.callback = URI.create(builder.callback);
    }

    public static Builder builder() {
        return new Builder();
    }

    public URI getCallback() {
        return this.callback;
    }

    public Boolean getCnam() {
        return this.cnam;
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        this.conditionalAdd("callback", this.callback);
        return params;
    }

    public static final class Builder {
        private Boolean cnam;
        private String number;
        private String country;
        private String callback;

        private Builder() {
        }

        public Builder number(String number) {
            this.number = number;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder cnam(boolean cnam) {
            this.cnam = cnam;
            return this;
        }

        public Builder callback(String url) {
            this.callback = url;
            return this;
        }

        public AdvancedInsightAsyncRequest build() {
            return new AdvancedInsightAsyncRequest(this);
        }
    }
}

